/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.login.records;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.ISlot;
import org.jetbrains.annotations.NotNull;

public final class CRecordSessionGetLongToken
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject("bb156b98-b587-4e47-8c3a-eba8f1f512b8");
    public static final String NAME = "SessionGetLongToken";
    public static final String DESCRIPTION = "Get a long session token with a short session token.";
    public static final String SLOT_LONG_TOKEN = "10";
    public static final String SLOT_SHORT_TOKEN = "1";
    public static final String[] NAMESPACES = new String[0];
    public static final boolean IS_NANO_SERVICE = false;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static byte[] getLongToken(@NotNull CRecord aRecord, byte[] aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_LONG_TOKEN);
        if (slot == null) {
            return aDefault;
        }
        return (byte[])slot.getValue();
    }

    public static byte[] getShortToken(@NotNull CRecord aRecord, byte[] aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_SHORT_TOKEN);
        if (slot == null) {
            return aDefault;
        }
        return (byte[])slot.getValue();
    }

    public static void setLongToken(@NotNull CRecord aRecord, byte[] aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.BYTE_ARRAY, aValue);
        aRecord.addSlot(SLOT_LONG_TOKEN, slot);
    }

    public static void setShortToken(@NotNull CRecord aRecord, byte[] aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.BYTE_ARRAY, aValue);
        aRecord.addSlot(SLOT_SHORT_TOKEN, slot);
    }
}

