/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.slot;

import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISingleSlotTypeFactory;
import de.sillysky.nyssr.slot.ISlot;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

final class CSlotId
implements ISlot,
ISingleSlotTypeFactory {
    @Nullable
    private final IId mValue;

    CSlotId() {
        this.mValue = null;
    }

    private CSlotId(@Nullable IId aValue) {
        this.mValue = aValue;
    }

    @NotNull
    private static CSlotId fromObject(@Nullable Object aValue) {
        if (aValue instanceof IId) {
            return new CSlotId((IId)aValue);
        }
        if (aValue instanceof String) {
            return CSlotId.fromString((String)aValue);
        }
        if (aValue instanceof List) {
            return CSlotId.fromList((List)aValue);
        }
        return new CSlotId();
    }

    @NotNull
    private static CSlotId fromList(@NotNull List<?> aValue) {
        CSlotId result;
        if (aValue.isEmpty()) {
            result = new CSlotId();
        } else {
            Object object = aValue.get(0);
            result = CSlotId.fromObject(object);
        }
        return result;
    }

    @NotNull
    private static CSlotId fromStream(@NotNull DataInput aStream) throws IOException {
        IId value = CIdFactory.fromStream(aStream, true);
        return new CSlotId(value);
    }

    @NotNull
    private static CSlotId fromString(@NotNull String aValue) {
        IId value = CIdFactory.fromObject(aValue);
        return new CSlotId(value);
    }

    @Override
    @Nullable
    public ISlot fromObject(@NotNull CSlotType aType, @Nullable Object aValue) {
        if (this.getType().equals(aType)) {
            return CSlotId.fromObject(aValue);
        }
        return null;
    }

    @Override
    @NotNull
    public ISlot fromJson(@Nullable Object aValue, @NotNull Map<Integer, byte[]> aByteArrayStore) {
        IId id = CIdFactory.fromObject(aValue);
        return new CSlotId(id);
    }

    @Override
    public boolean equals(@Nullable Object aObj) {
        if (this == aObj) {
            return true;
        }
        if (aObj == null) {
            return false;
        }
        if (this.getClass() != aObj.getClass()) {
            return false;
        }
        CSlotId other = (CSlotId)aObj;
        return Objects.equals(this.mValue, other.mValue);
    }

    @Override
    @NotNull
    public Class<?> getClassOfProducedObject() {
        return IId.class;
    }

    @Override
    @NotNull
    public ISlot copy() {
        return this;
    }

    @Override
    @NotNull
    public CSlotType getType() {
        return CCommonSlotType.ID;
    }

    @Override
    @Nullable
    public Object getValue() {
        return this.mValue;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.mValue);
    }

    @Override
    public boolean isContentEqualTo(@Nullable Object aValue) {
        return Objects.equals(this.mValue, aValue);
    }

    @Override
    @Nullable
    public ISlot readSlot(@NotNull DataInput aStream, @NotNull CSlotType aType) throws IOException {
        if (this.getType().equals(aType)) {
            return CSlotId.fromStream(aStream);
        }
        return null;
    }

    @Override
    public void toStream(@NotNull DataOutput aStream) throws IOException {
        CIdFactory.toStream(aStream, this.mValue);
    }

    @NotNull
    public String toString() {
        if (this.mValue == null) {
            return "null";
        }
        return this.mValue.toString();
    }

    @Override
    @NotNull
    public String valueToString() {
        if (this.mValue == null) {
            return "null";
        }
        return this.mValue.valueToString();
    }

    @Override
    @Nullable
    public @Unmodifiable Object toJson(@NotNull Map<Integer, byte[]> aBinaries) {
        return this.mValue == null ? null : this.mValue.valueToString();
    }
}

