/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.session.verifier;

import de.sillysky.nyssr.impl.session.verifier.CSessionVerifier;
import de.sillysky.nyssr.impl.session.verifier.IDependencies;
import de.sillysky.nyssr.kernel.configuration.IKernelConfiguration;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.namespace.IRecordHelper;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.service.IServiceStarter;
import org.jetbrains.annotations.NotNull;

public class CPackageImplSessionVerifier
implements IServiceStarter,
IDependencies {
    private static final String FILTER = "nid=SYSTEM";
    private IService mService;
    private IKernelConfiguration mKernelConfiguration;
    private INamespace mSystemNamespace;
    private IRecordHelper mRecordHelper;

    @Override
    public void getDependencies(@NotNull IServiceDependencyList aDependencyList) {
        aDependencyList.add(IKernelConfiguration.class);
        aDependencyList.add(IRecordHelper.class);
        aDependencyList.add(INamespace.class, FILTER);
    }

    @Override
    public void start(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        if (this.mService == null) {
            this.mKernelConfiguration = aServiceRegistry.getServiceOrThrow(IKernelConfiguration.class);
            this.mRecordHelper = aServiceRegistry.getServiceOrThrow(IRecordHelper.class);
            this.mSystemNamespace = aServiceRegistry.getServiceOrThrow(INamespace.class, FILTER);
            this.mService = new CSessionVerifier(this);
            this.mService.activate(aServiceRegistry);
        }
    }

    @Override
    public void stop(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        if (this.mService != null) {
            this.mService.deactivate(aServiceRegistry);
            this.mService = null;
        }
    }

    @Override
    @NotNull
    public IKernelConfiguration getKernelConfiguration() {
        return this.mKernelConfiguration;
    }

    @Override
    @NotNull
    public INamespace getSystemNamespace() {
        return this.mSystemNamespace;
    }

    @Override
    @NotNull
    public IRecordHelper getRecordHelper() {
        return this.mRecordHelper;
    }
}

