/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.json.parser;

import de.sillysky.nyssr.json.CJsonArray;
import de.sillysky.nyssr.json.CJsonObject;
import java.util.Stack;
import org.json.simple.parser.ContentHandler;

public class CContentHandler
implements ContentHandler {
    private final boolean mNormalizeKey;
    private Stack<Object> mStack = null;

    public CContentHandler(boolean aNormalizeKey) {
        this.mNormalizeKey = aNormalizeKey;
    }

    private void consumeValue(Object value) {
        if (this.mStack.size() == 0) {
            this.mStack.push(value);
        } else {
            Object prev = this.mStack.peek();
            if (prev instanceof CJsonArray) {
                CJsonArray array = (CJsonArray)prev;
                array.add(value);
            } else {
                this.mStack.push(value);
            }
        }
    }

    @Override
    public boolean endArray() {
        this.trackBack();
        return true;
    }

    @Override
    public void endJSON() {
    }

    @Override
    public boolean endObject() {
        this.trackBack();
        return true;
    }

    @Override
    public boolean endObjectEntry() {
        Object value = this.mStack.pop();
        Object key = this.mStack.pop();
        CJsonObject parent = (CJsonObject)this.mStack.peek();
        parent.put((String)key, value);
        return true;
    }

    public CJsonObject getResult() {
        if (this.mStack == null || this.mStack.size() == 0) {
            return null;
        }
        return (CJsonObject)this.mStack.peek();
    }

    private String peekKey() {
        if (this.mStack.isEmpty()) {
            return "";
        }
        Object o = this.mStack.peek();
        return o instanceof String ? (String)o : "";
    }

    @Override
    public boolean primitive(Object aO) {
        this.consumeValue(aO);
        return true;
    }

    @Override
    public boolean startArray() {
        String key = this.peekKey();
        CJsonArray array = new CJsonArray();
        this.consumeValue(array);
        this.mStack.push(array);
        return true;
    }

    @Override
    public void startJSON() {
        this.mStack = new Stack();
    }

    @Override
    public boolean startObject() {
        String key = this.peekKey();
        CJsonObject object = new CJsonObject(this.mNormalizeKey);
        this.consumeValue(object);
        this.mStack.push(object);
        return true;
    }

    @Override
    public boolean startObjectEntry(String aKey) {
        this.mStack.push(aKey);
        return true;
    }

    private void trackBack() {
        if (this.mStack.size() > 1) {
            Object value = this.mStack.pop();
            Object prev = this.mStack.peek();
            if (prev instanceof String) {
                this.mStack.push(value);
            }
        }
    }
}

