/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.cli;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.cli.ICommandLineInterface;
import de.sillysky.nyssr.cli.records.CRecordCliAddHandler;
import de.sillysky.nyssr.cli.records.CRecordCliAttachDisplay;
import de.sillysky.nyssr.cli.records.CRecordCliGetHelp;
import de.sillysky.nyssr.cli.records.CRecordCliHandle;
import de.sillysky.nyssr.cli.records.CRecordCliRemoveHandler;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.common.CWellKnownNID;
import de.sillysky.nyssr.impl.cli.CCommandEntry;
import de.sillysky.nyssr.impl.cli.CHandlerList;
import de.sillysky.nyssr.impl.cli.IDependencies;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.impl.service.CServiceRegistry;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.nanoservice.INanoServiceRegistry;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.util.CUtilString;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CCommandLineInterfaceTarget
extends CTarget
implements IService,
ICommandLineInterface {
    private static final ILogger LOG = CLoggerFactory.getLogger(CCommandLineInterfaceTarget.class);
    private final IDependencies mDependencies;
    private final CHandlerList mHandlerList = new CHandlerList();

    CCommandLineInterfaceTarget(@NotNull IDependencies aDependencies) {
        this.mDependencies = aDependencies;
    }

    @Override
    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordCliAddHandler.ID, this::asyncAddHandler);
        this.addMessageHandler(CRecordCliRemoveHandler.ID, this::asyncRemoveHandler);
        this.addMessageHandler(CRecordCliAttachDisplay.ID, this::asyncAttachDisplay);
        this.addMessageHandler(CRecordCliGetHelp.ID, this::asyncGetHelp);
        this.addMessageHandler(CRecordCliHandle.ID, this::asyncHandle);
        INamespace ns = this.mDependencies.getNamespaceRegistry().getNamespace(CWellKnownNID.SYSTEM);
        assert (ns != null);
        IId tid = CIdFactory.fromObject("CliManager");
        ns.getTargetRegistry().registerTarget(this, tid);
    }

    @Override
    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        aServiceRegistry.deregisterService(this);
        this.deregisterTarget();
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CTargetAddress address = this.getAddress();
        INamespace ns = this.mDependencies.getNamespaceRegistry().getNamespace(CWellKnownNID.SYSTEM);
        assert (ns != null);
        INanoServiceRegistry sr = ns.getNanoServiceRegistry();
        sr.addNanoServiceAndObserver(CRecordCliAttachDisplay.class, address, false);
        sr.addNanoServiceAndObserver(CRecordCliAddHandler.class, address, false);
        sr.addNanoServiceAndObserver(CRecordCliRemoveHandler.class, address, false);
        aEnvelope.setResultSuccess();
        CServiceRegistry.getInstance().registerService(ICommandLineInterface.class, this);
        return true;
    }

    private boolean asyncAddHandler(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        String[] commands = CRecordCliAddHandler.getCommand(aRecord, null);
        CUtilCheck.checkNotNull(commands, "Missing Commands", new Object[0]);
        String[] helpArray = CRecordCliAddHandler.getHelp(aRecord, null);
        CUtilCheck.checkNotNull(helpArray, "Missing Help", new Object[0]);
        CUtilCheck.checkTrue(helpArray.length == commands.length, "Help array length does not match command array length", new Object[0]);
        CTargetAddress sender = aEnvelope.getSender();
        for (int i = 0; i < commands.length; ++i) {
            LOG.debug("CLI: Add handler {} for <{}>.", sender, commands[i]);
            this.mHandlerList.addHandler(commands[i], helpArray[i], sender);
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncRemoveHandler(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CTargetAddress sender = aEnvelope.getSender();
        String command = CRecordCliRemoveHandler.getCommand(aRecord, null);
        if (CUtilString.isValid(command)) {
            LOG.debug("CLI: Remove handler {} for <{}>.", sender, command);
            this.mHandlerList.removeHandler(command, sender);
        } else {
            LOG.debug("CLI: Remove all handler for {}.", sender);
            this.mHandlerList.removeHandler(sender);
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncAttachDisplay(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncGetHelp(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        String helpText = this.createHelp();
        CRecordCliGetHelp.setHelp(aRecord, helpText);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncHandle(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        String commandLine = CRecordCliHandle.getCommandLine(aRecord, "");
        CTargetAddress handlerAddress = this.handleLine(commandLine, aRecord);
        if (handlerAddress == null) {
            aEnvelope.setResult(5, "Command handler not found.");
        } else {
            aEnvelope.setResultSuccess();
            aEnvelope.forwardMessage(handlerAddress);
        }
        return true;
    }

    @NotNull
    private String createHelp() {
        StringBuilder sb = new StringBuilder(2000);
        sb.append("login\n");
        sb.append("    Enter user name and password for login\n");
        sb.append("logout\n");
        sb.append("    Logs you out\n");
        Iterator<CCommandEntry> it = this.mHandlerList.iterator();
        while (it.hasNext()) {
            CCommandEntry e = it.next();
            sb.append(e.getCommand()).append("\n");
            sb.append("    ").append(e.getHelp()).append("\n");
        }
        return sb.toString();
    }

    @Nullable
    private CTargetAddress handleLine(@NotNull String aLine, @NotNull CRecord aRecord) {
        CCommandEntry entry = null;
        try {
            String line = aLine.toLowerCase();
            while (!line.isEmpty()) {
                entry = this.mHandlerList.get(line);
                if (entry != null) {
                    String a1 = aLine.substring(line.length()).trim();
                    String[] arguments = a1.isEmpty() ? new String[]{} : a1.split(" ");
                    CRecordCliHandle.setCommand(aRecord, line);
                    CRecordCliHandle.setArguments(aRecord, arguments);
                    return entry.getAddress();
                }
                int pos = line.lastIndexOf(32);
                if (pos >= 0) {
                    line = line.substring(0, pos);
                    continue;
                }
                break;
            }
        }
        catch (CException aE) {
            LOG.error("Can't send CLI Command <{}> to receiver {}:", aLine, entry);
        }
        return null;
    }
}

