/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.id.uuid;

import de.sillysky.nyssr.id.EIdType;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.IIdFactory;
import de.sillysky.nyssr.id.uuid.CIdUuid;
import de.sillysky.nyssr.util.CUtilUuid;
import java.io.DataInput;
import java.io.IOException;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

class CIdUuidFactory
implements IIdFactory {
    CIdUuidFactory() {
    }

    @Override
    public IId fromObject(Object aObj) {
        if (aObj != null) {
            UUID u = null;
            if (aObj instanceof UUID) {
                u = (UUID)aObj;
            } else if (aObj instanceof String) {
                u = CUtilUuid.fromString((String)aObj);
            }
            if (u != null && !CUtilUuid.isEmpty(u)) {
                return new CIdUuid(u);
            }
        }
        return null;
    }

    @Override
    @NotNull
    public IId random() {
        return new CIdUuid();
    }

    @Override
    @NotNull
    public IId fromStream(@NotNull DataInput aStream) throws IOException {
        UUID uuid = CUtilUuid.nonNullFromStream(aStream);
        if (CUtilUuid.isEmpty(uuid)) {
            return IId.INVALID;
        }
        return new CIdUuid(uuid);
    }

    @Override
    @NotNull
    public EIdType getType() {
        return EIdType.UUID;
    }
}

