/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.exception;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.util.CUtilString;
import java.util.Objects;
import java.util.function.Consumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CUtilCheck {
    private static final ILogger LOG = CLoggerFactory.getLogger(CUtilCheck.class);

    private CUtilCheck() {
    }

    @Contract(value="null,_ -> param2; !null,_ -> !null")
    @NotNull
    public static <T> T notNull(@Nullable T aToCheck, @NotNull T aDefault) {
        if (aToCheck == null) {
            return aDefault;
        }
        return aToCheck;
    }

    @Contract(value="null,_,_ -> param2; !null,_,_ -> !null")
    @Nullable
    public static <T> T notNull(@Nullable T aToCheck, @NotNull T aDefault, @NotNull Consumer<T> aConsumer) {
        if (aToCheck == null) {
            return aDefault;
        }
        aConsumer.accept(aToCheck);
        return null;
    }

    @Contract(value="null,_,_ -> fail; !null,_,_ -> !null")
    @NotNull
    public static <T> T checkNotNull(@Nullable T aCheckMe, @Nullable String aMessage, Object ... aArgs) throws NullPointerException {
        if (aCheckMe == null) {
            String s = CUtilString.isEmpty(aMessage) ? "Argument is null." : String.format(aMessage, aArgs);
            throw new NullPointerException(s);
        }
        return aCheckMe;
    }

    @Contract(value="null,_,_ -> fail; !null,_,_ -> !null")
    @NotNull
    public static String checkEmptyString(@Nullable Object aCheckMe, @Nullable String aMessage, Object ... aArgs) throws NullPointerException {
        if (!(aCheckMe instanceof String) || ((String)aCheckMe).isEmpty()) {
            if (CUtilString.isEmpty(aMessage)) {
                throw new NullPointerException("Argument is missing.");
            }
            throw new NullPointerException(String.format(aMessage, aArgs));
        }
        return (String)aCheckMe;
    }

    public static void checkEmptyStringEx(@Nullable Object aCheckMe, @Nullable String aMessage, Object ... aArgs) throws CException {
        if (!(aCheckMe instanceof String) || ((String)aCheckMe).isEmpty()) {
            CException ex = new CException(7);
            if (CUtilString.isEmpty(aMessage)) {
                ex.append("Argument is missing.");
            } else {
                ex.append(String.format(aMessage, aArgs));
            }
            throw ex;
        }
    }

    public static void checkEqual(@Nullable Object aCheckMe, @Nullable Object aRef, @Nullable String aMessage, Object ... aArgs) throws IllegalArgumentException {
        if (!Objects.equals(aCheckMe, aRef)) {
            if (CUtilString.isEmpty(aMessage)) {
                String msg = String.format("Argument %s is not equal to %s.", aCheckMe, aRef);
                throw new IllegalArgumentException(msg);
            }
            String msg = String.format(aMessage, aArgs);
            throw new IllegalArgumentException(msg);
        }
    }

    public static void checkEqualEx(@Nullable Object aCheckMe, @Nullable Object aRef, @Nullable String aMessage, Object ... aArgs) throws CException {
        if (!Objects.equals(aCheckMe, aRef)) {
            String msg = CUtilString.isEmpty(aMessage) ? String.format("Argument %s is not equal to %s.", aCheckMe, aRef) : String.format(aMessage, aArgs);
            throw new CException(30).append(msg);
        }
    }

    @Contract(value="null,_,_ -> fail")
    public static void checkNotNullEx(@Nullable Object aCheckMe, @Nullable String aMessage, Object ... aArgs) throws CException {
        if (aCheckMe == null) {
            String s = CUtilString.isEmpty(aMessage) ? "Argument is null." : String.format(aMessage, aArgs);
            throw new CException(7).append(s);
        }
    }

    public static void checkNull(@Nullable Object aCheckMe, @Nullable String aMessage, Object ... aArgs) throws IllegalArgumentException {
        if (aCheckMe != null) {
            if (CUtilString.isEmpty(aMessage)) {
                throw new IllegalArgumentException("Argument is not null.");
            }
            throw new IllegalArgumentException(String.format(aMessage, aArgs));
        }
    }

    @NotNull
    public static String checkOptionalString(@Nullable Object aCheckMe, @NotNull String aDefault, @Nullable String aMessage, Object ... aArgs) {
        String result = aDefault;
        if (!(aCheckMe instanceof String) || ((String)aCheckMe).isEmpty()) {
            if (!CUtilString.isEmpty(aMessage)) {
                LOG.warn(String.format(aMessage, aArgs));
            }
        } else {
            result = (String)aCheckMe;
        }
        return result;
    }

    public static void checkTrue(boolean aCheckMe, @Nullable String aMessage, Object ... aArgs) throws IllegalArgumentException {
        if (!aCheckMe) {
            if (CUtilString.isEmpty(aMessage)) {
                throw new IllegalArgumentException("Argument is false.");
            }
            throw new IllegalArgumentException(String.format(aMessage, aArgs));
        }
    }

    public static void checkTrueEx(boolean aCheckMe, @Nullable String aMessage, Object ... aArgs) throws CException {
        if (!aCheckMe) {
            CException ex = new CException(7);
            if (CUtilString.isEmpty(aMessage)) {
                ex.append("Argument is false.");
            } else {
                ex.append(String.format(aMessage, aArgs));
            }
            throw ex;
        }
    }

    @Contract(value="_, null -> fail")
    @NotNull
    public static <T> T checkInstance(@NotNull Class<T> aReference, @Nullable Object aCheckMe) throws IllegalArgumentException {
        if (aCheckMe == null || !aCheckMe.getClass().equals(aReference)) {
            throw new IllegalArgumentException("This is not Object of type " + aReference.getName());
        }
        return (T)aCheckMe;
    }

    public static void checkArgument(@Nullable Object aCheckMe, @NotNull String aNameOfArgument) throws CException {
        if (aCheckMe == null || aCheckMe instanceof String && ((String)aCheckMe).isEmpty()) {
            throw new CException(7).append("Argument missing: ").append(aNameOfArgument);
        }
    }
}

