/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.address.filter;

import de.sillysky.nyssr.address.CNodeId;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.address.filter.CTargetAddressFilter;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CUtilTargetAddressFilter {
    private CUtilTargetAddressFilter() {
    }

    private static boolean privateFilterIDs(IId aToCheck, IId aFilter) {
        if (aFilter == null || IId.INVALID.equals(aFilter)) {
            return true;
        }
        return CIdFactory.equals(aFilter, aToCheck);
    }

    private static boolean privateFilterNodeIds(CNodeId aToCheck, CNodeId aFilter) {
        if (aFilter == null || !aFilter.isValid()) {
            return true;
        }
        return CNodeId.equals(aFilter, aToCheck);
    }

    private static boolean privateFilterOneAddress(CTargetAddress aToCheck, CTargetAddressFilter aFilter) {
        if (!CUtilTargetAddressFilter.privateFilterNodeIds(aToCheck.getNodeId(), aFilter.getNodeId())) {
            return false;
        }
        if (!CUtilTargetAddressFilter.privateFilterIDs(aToCheck.getNID(), aFilter.getNID())) {
            return false;
        }
        return CUtilTargetAddressFilter.privateFilterIDs(aToCheck.getTID(), aFilter.getTID());
    }

    @NotNull
    public static Collection<CTargetAddress> filter(@NotNull Collection<CTargetAddress> aInput, @NotNull CTargetAddressFilter aFilter) throws CException {
        CUtilCheck.checkNotNullEx(aInput, "Missing Input List", new Object[0]);
        ArrayList<CTargetAddress> output = new ArrayList<CTargetAddress>();
        for (CTargetAddress o : aInput) {
            if (!CUtilTargetAddressFilter.privateFilterOneAddress(o, aFilter)) continue;
            output.add(o);
        }
        return output;
    }

    public static boolean filter(@NotNull CTargetAddress aInput, @Nullable Collection<CTargetAddressFilter> aFilters) {
        CUtilCheck.checkNotNull(aInput, "Missing Input Address", new Object[0]);
        if (aFilters == null || aFilters.isEmpty()) {
            return true;
        }
        for (CTargetAddressFilter f : aFilters) {
            if (!CUtilTargetAddressFilter.privateFilterOneAddress(aInput, f)) continue;
            return true;
        }
        return false;
    }
}

