/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.model.events.layout;

import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonInteger;
import de.sillysky.nyssr.remoteskin.model.events.IRemoteSkinEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CEventGridLayout
implements IRemoteSkinEvent {
    private static final String ROWS = "rows";
    private static final String COLUMNS = "columns";
    private static final String HGAP = "hgap";
    private static final String VGAP = "vgap";
    private static final int DEFAULT_GAP = 0;
    private static final int DEFAULT_ROWS = 1;
    private static final int DEFAULT_COLUMNS = 0;
    private final int mRows;
    private final int mColumns;
    private final int mHorizontalGap;
    private final int mVerticalGap;

    public CEventGridLayout(int aRows, int aColumns, int aHorizontalGap, int aVerticalGap) {
        this.mRows = aRows;
        this.mColumns = aColumns;
        this.mHorizontalGap = aHorizontalGap;
        this.mVerticalGap = aVerticalGap;
    }

    public CEventGridLayout() {
        this(1, 0, 0, 0);
    }

    @Nullable
    public static CEventGridLayout create(@Nullable Object aValue) {
        boolean enabled;
        if (aValue instanceof CJsonObject) {
            CJsonObject jo = (CJsonObject)aValue;
            int rows = CUtilJsonInteger.fromJson((CJsonObject)jo, (String)ROWS, (int)1);
            int columns = CUtilJsonInteger.fromJson((CJsonObject)jo, (String)COLUMNS, (int)0);
            int hGap = CUtilJsonInteger.fromJson((CJsonObject)jo, (String)HGAP, (int)0);
            int vGap = CUtilJsonInteger.fromJson((CJsonObject)jo, (String)VGAP, (int)0);
            return new CEventGridLayout(rows, columns, hGap, vGap);
        }
        if (aValue instanceof Boolean && (enabled = ((Boolean)aValue).booleanValue())) {
            return new CEventGridLayout();
        }
        return null;
    }

    @Override
    @NotNull
    public Object toJson() {
        CJsonObject jo = new CJsonObject(true);
        if (this.mRows != 1) {
            jo.put(ROWS, (Object)this.mRows);
        }
        if (this.mColumns != 1) {
            jo.put(COLUMNS, (Object)this.mColumns);
        }
        if (this.mHorizontalGap != 0) {
            jo.put(HGAP, (Object)this.mHorizontalGap);
        }
        if (this.mVerticalGap != 0) {
            jo.put(VGAP, (Object)this.mVerticalGap);
        }
        return jo;
    }

    public int getRows() {
        return this.mRows;
    }

    public int getColumns() {
        return this.mColumns;
    }

    public int getHorizontalGap() {
        return this.mHorizontalGap;
    }

    public int getVerticalGap() {
        return this.mVerticalGap;
    }
}

