/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.model.events;

import de.sillysky.nyssr.json.CJsonArray;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonInteger;
import de.sillysky.nyssr.remoteskin.model.events.IRemoteSkinEvent;
import de.sillysky.nyssr.util.CUtilInteger;
import de.sillysky.nyssr.util.swing.point.CUtilPoint;
import java.awt.Point;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CEventPoint
implements IRemoteSkinEvent {
    private static final String X = "x";
    private static final String Y = "y";
    private final int mX;
    private final int mY;

    public CEventPoint(int aX, int aY) {
        this.mX = aX;
        this.mY = aY;
    }

    public CEventPoint(@NotNull Point aPoint) {
        this.mX = aPoint.x;
        this.mY = aPoint.y;
    }

    @Nullable
    public static CEventPoint create(@Nullable Object aValue) {
        if (aValue instanceof CJsonArray) {
            CJsonArray arr = (CJsonArray)aValue;
            List children = arr.getChildren();
            if (children.size() >= 2) {
                int x = CUtilInteger.fromObject(children.get(0), (int)0);
                int y = CUtilInteger.fromObject(children.get(1), (int)0);
                return new CEventPoint(x, y);
            }
        } else {
            Point point;
            if (aValue instanceof CJsonObject) {
                CJsonObject jo = (CJsonObject)aValue;
                int x = CUtilJsonInteger.fromJson((CJsonObject)jo, (String)X, (int)0);
                int y = CUtilJsonInteger.fromJson((CJsonObject)jo, (String)Y, (int)0);
                return new CEventPoint(x, y);
            }
            if (aValue instanceof String && (point = CUtilPoint.parse((String)((String)aValue), null)) != null) {
                return new CEventPoint(point);
            }
        }
        return null;
    }

    public int getX() {
        return this.mX;
    }

    public int getY() {
        return this.mY;
    }

    public Point createPoint() {
        return new Point(this.mX, this.mY);
    }

    @Override
    @NotNull
    public Object toJson() {
        CJsonArray array = new CJsonArray();
        array.add((Object)this.mX);
        array.add((Object)this.mY);
        return array;
    }
}

