/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.model.events;

import de.sillysky.nyssr.json.CJsonArray;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonBoolean;
import de.sillysky.nyssr.remoteskin.model.events.IRemoteSkinEvent;
import de.sillysky.nyssr.remoteskin.model.types.CDataKeyModifiers;
import de.sillysky.nyssr.util.swing.key.EKeyModifier;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CEventButtonPressedNotification
implements IRemoteSkinEvent {
    public static final String MODIFIERS = "mod";
    public static final String SELECTED = "selected";
    private final boolean mIsSelected;
    private final Collection<EKeyModifier> mModifiers;

    public CEventButtonPressedNotification(boolean aIsSelected, @Nullable Collection<EKeyModifier> aModifiers) {
        this.mIsSelected = aIsSelected;
        this.mModifiers = aModifiers == null ? new ArrayList() : aModifiers;
    }

    @Nullable
    public static CEventButtonPressedNotification create(@Nullable Object aValue) {
        if (aValue instanceof CJsonObject) {
            CJsonObject jo = (CJsonObject)aValue;
            boolean isSelected = CUtilJsonBoolean.fromJson((CJsonObject)jo, (String)SELECTED, (boolean)false);
            Object value = jo.getValue(MODIFIERS);
            CDataKeyModifiers dataKeyModifiers = CDataKeyModifiers.create(value);
            Collection<EKeyModifier> modifiers = dataKeyModifiers != null ? dataKeyModifiers.getModifiers() : null;
            return new CEventButtonPressedNotification(isSelected, modifiers);
        }
        return null;
    }

    @Override
    @NotNull
    public Object toJson() {
        CJsonObject jo = new CJsonObject(true);
        jo.put(SELECTED, (Object)this.mIsSelected);
        CDataKeyModifiers data = new CDataKeyModifiers();
        data.addModifiers(this.mModifiers);
        CJsonArray arr = data.toJson();
        jo.put(MODIFIERS, (Object)arr);
        return jo;
    }

    public boolean isSelected() {
        return this.mIsSelected;
    }

    @NotNull
    public Collection<EKeyModifier> getModifiers() {
        return this.mModifiers;
    }
}

