/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.model;

import de.sillysky.nyssr.id.widget.CWidgetId;
import de.sillysky.nyssr.id.widget.CWidgetSetId;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.remoteskin.model.CAttributeHandlerList;
import de.sillysky.nyssr.remoteskin.model.CResizeDependency;
import de.sillysky.nyssr.remoteskin.model.CWidgetList;
import de.sillysky.nyssr.remoteskin.model.CWidgetSet;
import de.sillysky.nyssr.remoteskin.model.ENotification;
import de.sillysky.nyssr.remoteskin.model.IRemoteSkinClientContext;
import de.sillysky.nyssr.remoteskin.model.events.CEventMouseNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventPopupNotification;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.key.CUtilNormalize;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import javax.swing.ImageIcon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CWidget {
    private static final ILogger LOG = CLoggerFactory.getLogger(CWidget.class);
    private final CWidgetSet mWidgetSet;
    private final CWidgetList mChildren = new CWidgetList();
    private final CWidgetId mId;
    private final Properties mProperties = new Properties();
    private final CAttributeHandlerList mAttributeHandlerList;
    private Collection<CResizeDependency> mResizeDependencies = null;
    private CWidget mParent;

    public CWidget(@NotNull CWidgetSet aWidgetSet, @NotNull String aId) {
        this.mWidgetSet = aWidgetSet;
        this.mId = CWidgetId.create((String)aId, (CWidgetSetId)this.mWidgetSet.getId());
        this.mAttributeHandlerList = new CAttributeHandlerList(this);
    }

    public abstract void addListeners();

    public String toString() {
        return this.getWidgetType() + " (" + String.valueOf(this.getId()) + ")";
    }

    public void updatePopupItem(@NotNull MouseEvent aEvent) {
        CWidgetSet widgetSet = this.getWidgetSet();
        IRemoteSkinClientContext clientContext = widgetSet.getContext();
        List<Object> popupEvents = clientContext.getPopupEvents();
        CWidgetId id = this.getId();
        popupEvents.add(id);
    }

    @Nullable
    public Collection<CResizeDependency> getResizeDependencies() {
        return this.mResizeDependencies;
    }

    public void addResizeDependency(@Nullable CResizeDependency aDependency) {
        if (this.mResizeDependencies == null) {
            this.mResizeDependencies = new ArrayList<CResizeDependency>();
        }
        this.mResizeDependencies.add(aDependency);
    }

    @NotNull
    public abstract Component getComponent();

    @Nullable
    public Container getContentPane() {
        return null;
    }

    public final void createComponentTree(@Nullable CWidget aParent) {
        if (aParent != null) {
            aParent.addChildComponent(this);
        }
        for (CWidget w : this.children()) {
            w.createComponentTree(this);
        }
    }

    public abstract void addChildComponent(@NotNull CWidget var1);

    @NotNull
    public CWidget getRoot() {
        CWidget result = this;
        CWidget parent = this.mParent;
        while (parent != null) {
            result = parent;
            parent = parent.mParent;
        }
        return result;
    }

    @Nullable
    public Window getParentWindow() {
        for (CWidget parent = this.getParent(); parent != null; parent = parent.getParent()) {
            Component temp = parent.getComponent();
            if (!(temp instanceof Window)) continue;
            return (Window)temp;
        }
        return null;
    }

    public void show() {
        this.pack();
        this.getComponent().setVisible(true);
        this.getComponent().revalidate();
    }

    public void pack() {
    }

    public void enrichMouseEvent(@NotNull CEventMouseNotification aEvent) {
    }

    public void enrichPopupEvent(@NotNull CEventPopupNotification aEvent) {
    }

    public void notifyWidget(@NotNull ENotification aNotification, Object ... aObjects) {
    }

    public void notifyComponentCreated() {
    }

    public final void notifyChildren(@NotNull ENotification aNotification, Object ... aArguments) {
        this.notifyWidget(aNotification, aArguments);
        Collection<CWidget> cc = this.mChildren.getAll();
        for (CWidget c : cc) {
            c.notifyChildren(aNotification, aArguments);
        }
    }

    public void addNotification(@NotNull String aKey, @NotNull Object aValue) {
        this.getWidgetSet().addNotification(this.getId(), aKey, aValue);
    }

    public void sendNotification() {
        this.getWidgetSet().sendNotifications();
    }

    @Nullable
    public CWidget getParent() {
        return this.mParent;
    }

    public void setParent(@Nullable CWidget aParent) {
        if (aParent != this.mParent) {
            if (this.mParent != null) {
                this.mParent.removeChild(this);
            }
            this.mParent = aParent;
            this.notifyWidget(this.mParent == null ? ENotification.PARENT_LOST : ENotification.GOT_PARENT, new Object[0]);
        }
    }

    public void addChildWidget(@NotNull CWidget aWidget) {
        this.mChildren.add(aWidget);
        aWidget.setParent(this);
    }

    @NotNull
    public Collection<CWidget> children() {
        return this.mChildren.getAll();
    }

    public int getNumberOfChildren() {
        return this.mChildren.size();
    }

    public int getDeepNumberOfChildren() {
        int number = this.mChildren.size();
        if (number > 0) {
            Collection<CWidget> children = this.mChildren.getAll();
            for (CWidget w : children) {
                number += w.getDeepNumberOfChildren();
            }
        }
        return number;
    }

    public final void applyAttributes(@NotNull CJsonObject aAttributes) {
        Collection keys = aAttributes.keys();
        for (String key : keys) {
            Object o = aAttributes.getValue(key);
            String normKey = CUtilNormalize.normalize((String)key);
            this.mAttributeHandlerList.handleAttribute(normKey, o);
        }
        this.mAttributeHandlerList.handleAttribute("finish", true);
    }

    @NotNull
    public CWidgetId getId() {
        return this.mId;
    }

    public abstract String getWidgetType();

    @NotNull
    public CWidgetSet getWidgetSet() {
        return this.mWidgetSet;
    }

    @NotNull
    public Properties getProperties() {
        return this.mProperties;
    }

    @NotNull
    public IRemoteSkinClientContext getContext() {
        return this.mWidgetSet.getContext();
    }

    void removeChild(@NotNull CWidget aWidget) {
        Component component = this.getComponent();
        if (component instanceof Container) {
            Container c = (Container)component;
            Component co = aWidget.getComponent();
            c.remove(co);
        }
        this.mChildren.remove(aWidget);
    }

    public void unmount() {
        LOG.debug("Unmount Widget {}", new Object[]{this.getId()});
        this.getComponent().setVisible(false);
        CWidget parent = this.getParent();
        if (parent != null) {
            parent.removeChild(this);
            this.mParent = null;
        }
        this.mWidgetSet.notifyWidgetUnmounted(this);
        Collection<CWidget> list = this.mChildren.getAll();
        for (CWidget w : list) {
            w.unmount();
        }
    }

    public void replaceChild(@NotNull CWidget aToReplace, @NotNull CWidget aReplacement, boolean aChildrenOnly) {
        this.mChildren.replaceWidget(aToReplace, aReplacement, aChildrenOnly);
    }

    public void fileArrived(@NotNull String aRelativePath, @Nullable Object aToken, @NotNull File aFile) {
    }

    public void fileArrived(@NotNull String aRelativePath, @Nullable Object aToken, byte[] aBytes) {
    }

    public void fileArrived(@NotNull String aRelativePath, @Nullable Object aToken, @NotNull ImageIcon aImage) {
    }

    public CAttributeHandlerList getAttributeHandlerList() {
        return this.mAttributeHandlerList;
    }

    public boolean dump(StringBuilder aSb, int aLeadingTabCount, String aFilter) {
        if (this.mChildren.size() > 0 || CUtilString.isEmpty((String)aFilter)) {
            boolean write = this.mId.valueToString().contains(aFilter);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < aLeadingTabCount; ++i) {
                sb.append("    ");
            }
            sb.append(this.getWidgetType()).append(", id=").append(this.mId).append(CUtilString.CRLF);
            for (CWidget w : this.mChildren.getAll()) {
                boolean success = w.dump(sb, aLeadingTabCount + 1, aFilter);
                if (!success) continue;
                write = true;
            }
            if (write) {
                aSb.append((CharSequence)sb);
                return true;
            }
        }
        return false;
    }
}

