/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.network.router.records;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISlot;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public final class CRecordNetworkGetNodeRecord
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject((Object)"481b33c0-cda1-47c8-a7f7-04e41030fee3");
    public static final String NAME = "NetworkGetNodeRecord";
    public static final String DESCRIPTION = "Get a node record.";
    public static final String SLOT_INSTANCE = "2";
    public static final String SLOT_NODE_INFO = "100";
    public static final String SLOT_PUBLIC_KEY = "1";
    public static final String SLOT_SESSION_KEY = "101";
    public static final String SLOT_TIMESTAMP_SESSION_KEY = "102";
    public static final String[] NAMESPACES = new String[0];
    public static final boolean IS_NANO_SERVICE = false;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static UUID getInstance(@NotNull CRecord aRecord, UUID aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_INSTANCE);
        if (slot == null) {
            return aDefault;
        }
        return (UUID)slot.getValue();
    }

    public static CRecord getNodeInfo(@NotNull CRecord aRecord, CRecord aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_NODE_INFO);
        if (slot == null) {
            return aDefault;
        }
        return (CRecord)slot.getValue();
    }

    public static byte[] getPublicKey(@NotNull CRecord aRecord, byte[] aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_PUBLIC_KEY);
        if (slot == null) {
            return aDefault;
        }
        return (byte[])slot.getValue();
    }

    public static byte[] getSessionKey(@NotNull CRecord aRecord, byte[] aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_SESSION_KEY);
        if (slot == null) {
            return aDefault;
        }
        return (byte[])slot.getValue();
    }

    public static long getTimestampSessionKey(@NotNull CRecord aRecord, long aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_TIMESTAMP_SESSION_KEY);
        if (slot == null) {
            return aDefault;
        }
        return (Long)slot.getValue();
    }

    public static void setInstance(@NotNull CRecord aRecord, UUID aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.UUID, (Object)aValue);
        aRecord.addSlot(SLOT_INSTANCE, slot);
    }

    public static void setNodeInfo(@NotNull CRecord aRecord, CRecord aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.RECORD, (Object)aValue);
        aRecord.addSlot(SLOT_NODE_INFO, slot);
    }

    public static void setPublicKey(@NotNull CRecord aRecord, byte[] aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.BYTE_ARRAY, (Object)aValue);
        aRecord.addSlot(SLOT_PUBLIC_KEY, slot);
    }

    public static void setSessionKey(@NotNull CRecord aRecord, byte[] aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.BYTE_ARRAY, (Object)aValue);
        aRecord.addSlot(SLOT_SESSION_KEY, slot);
    }

    public static void setTimestampSessionKey(@NotNull CRecord aRecord, long aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.LONG, (Object)aValue);
        aRecord.addSlot(SLOT_TIMESTAMP_SESSION_KEY, slot);
    }
}

