/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.microservice.collector;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.impl.microservice.collector.IDependencies;
import de.sillysky.nyssr.impl.microservice.collector.IPrivateMicroServiceRegistryCollector;
import de.sillysky.nyssr.impl.microservice.collector.target.IMicroServiceCollectorTarget;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CMessage;
import de.sillysky.nyssr.message.IMicroServiceTransportHandler;
import de.sillysky.nyssr.microservice.collector.IMicroServiceRegistryCollector;
import de.sillysky.nyssr.microservice.registry.records.CRecordForwardToMicroServiceInstance;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.CRecordPrinter;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.util.CUtilString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

class CMicroServiceRegistryCollector
implements IService,
IMicroServiceRegistryCollector,
IPrivateMicroServiceRegistryCollector,
IMicroServiceTransportHandler {
    private static final ILogger LOG = CLoggerFactory.getLogger(CMicroServiceRegistryCollector.class);
    private static final ILogger LOG_COL = CLoggerFactory.getLogger((String)"microservice.collector");
    private final Set<CTargetAddress> mMicroServiceRegistries = new HashSet<CTargetAddress>();
    private final LinkedList<CMessage> mPendingMessages = new LinkedList();
    private final AtomicReference<IMicroServiceCollectorTarget> mTarget = new AtomicReference();
    private final IDependencies mDependencies;

    CMicroServiceRegistryCollector(@NotNull IDependencies aDependencies) {
        this.mDependencies = aDependencies;
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) {
        aServiceRegistry.registerService(IMicroServiceRegistryCollector.class, (Object)this);
        aServiceRegistry.registerService(IPrivateMicroServiceRegistryCollector.class, (Object)this);
        aServiceRegistry.registerService(IMicroServiceTransportHandler.class, (Object)this);
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        aServiceRegistry.deregisterService((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void addRegistry(@NotNull CTargetAddress aRegistry) {
        LOG_COL.info("MicroService Registry detected at {}", new Object[]{aRegistry.getNodeId()});
        Set<CTargetAddress> set = this.mMicroServiceRegistries;
        synchronized (set) {
            this.mMicroServiceRegistries.add(aRegistry);
        }
        IMicroServiceCollectorTarget target = this.mTarget.get();
        if (target != null) {
            LinkedList<CMessage> linkedList = this.mPendingMessages;
            synchronized (linkedList) {
                while (!this.mPendingMessages.isEmpty()) {
                    CMessage msg = this.mPendingMessages.getFirst();
                    try {
                        msg.getEnvelope().getReceivers().push(aRegistry);
                        this.mDependencies.getMessageSender().send(msg);
                        this.mPendingMessages.removeFirst();
                    }
                    catch (CException aE) {
                        LOG.error((Throwable)aE, "Error sending Message to MicroServiceRegistry {}", new Object[]{aRegistry});
                    }
                }
            }
        }
        this.dump();
    }

    public void forwardToMicroService(@NotNull IId aId, @NotNull CMessage aMessage, @NotNull CNodeAddress aNodeAddress) throws CException {
        aMessage.getEnvelope().ensureCompleteAddresses();
        CRecord rec = CRecordForwardToMicroServiceInstance.create();
        CRecordForwardToMicroServiceInstance.setMicroServiceId((CRecord)rec, (IId)aId);
        CRecordForwardToMicroServiceInstance.setMessage((CRecord)rec, (CMessage)aMessage);
        LOG_COL.debug("Forward to external MicroServiceRegistry: ID={}, RecordId={}, Sender={}", new Object[]{aId, aMessage.getRecord().getId(), aMessage.getEnvelope().getSender()});
        this.sendToExternalRegistry(rec, aNodeAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Collection<CTargetAddress> getAddresses() {
        Set<CTargetAddress> set = this.mMicroServiceRegistries;
        synchronized (set) {
            return new ArrayList<CTargetAddress>(this.mMicroServiceRegistries);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CTargetAddress getNextAddress() {
        CTargetAddress registry;
        Set<CTargetAddress> set = this.mMicroServiceRegistries;
        synchronized (set) {
            switch (this.mMicroServiceRegistries.size()) {
                case 0: {
                    registry = null;
                    break;
                }
                case 1: {
                    registry = this.mMicroServiceRegistries.iterator().next();
                    break;
                }
                default: {
                    registry = this.mDependencies.getRouter().getCheapestAddress(this.mMicroServiceRegistries);
                }
            }
        }
        LOG_COL.info("MicroService Registry requested: {}", new Object[]{registry == null ? "no registry available" : registry.getNodeId()});
        return registry;
    }

    private void logRemoved(@NotNull CNodeAddress aNode) {
        LOG_COL.info("MicroService Registry removed: {}", new Object[]{aNode});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyNodeRemoved(@NotNull CNodeAddress aNode) {
        Set<CTargetAddress> set = this.mMicroServiceRegistries;
        synchronized (set) {
            Iterator<CTargetAddress> it = this.mMicroServiceRegistries.iterator();
            while (it.hasNext()) {
                CTargetAddress a = it.next();
                if (!a.getNodeAddress().equals((Object)aNode)) continue;
                this.logRemoved(aNode);
                it.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeRegistry(@NotNull CTargetAddress aRegistry) {
        boolean removed;
        Set<CTargetAddress> set = this.mMicroServiceRegistries;
        synchronized (set) {
            removed = this.mMicroServiceRegistries.remove(aRegistry);
        }
        if (removed) {
            this.logRemoved(aRegistry.getNodeAddress());
            this.dump();
        }
        return removed;
    }

    private void sendToExternalRegistry(@NotNull CRecord aRecord, @NotNull CNodeAddress aNodeAddress) throws CException {
        IMicroServiceCollectorTarget target = this.mTarget.get();
        if (target == null) {
            throw new CException(5).append("No Target to send Message found");
        }
        target.sendToRegistry(aNodeAddress, aRecord);
    }

    @Override
    public void setTarget(IMicroServiceCollectorTarget aTarget) {
        this.mTarget.set(aTarget);
    }

    private void dump() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.getDump());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDump() {
        int count;
        StringBuilder sb = new StringBuilder(2000);
        sb.append(CUtilString.LINE_CRLF);
        sb.append("| MicroServiceRegistries:\n");
        if (this.mMicroServiceRegistries.size() == 0) {
            sb.append("    ---\n");
        } else {
            for (CTargetAddress reg : this.mMicroServiceRegistries) {
                sb.append("|     ").append(reg).append("\n");
            }
        }
        LinkedList<CMessage> linkedList = this.mPendingMessages;
        synchronized (linkedList) {
            count = this.mPendingMessages.size();
        }
        sb.append("| Pending Messages: ").append(count).append("\n");
        for (CMessage msg : this.mPendingMessages) {
            sb.append("|     ").append(new CRecordPrinter(msg.getRecord()).printShort()).append("\n");
        }
        sb.append(CUtilString.LINE_CRLF);
        return sb.toString();
    }

    public boolean handleMessage(@NotNull CMessage aMessage) {
        IId microServiceId = aMessage.getEnvelope().getMicroServiceId();
        if (!CIdFactory.isValid((IId)microServiceId)) {
            return false;
        }
        CTargetAddress nextAddress = this.getNextAddress();
        if (nextAddress == null) {
            this.mPendingMessages.add(aMessage);
            return true;
        }
        aMessage.getEnvelope().getReceivers().push(nextAddress);
        return false;
    }
}

