/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.link.cost.collector;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.impl.network.link.cost.collector.CCostEntry;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.network.link.cost.collector.records.CRecordBroadcastLinkCosts;
import de.sillysky.nyssr.record.CRecord;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

class CCostList {
    private static final ILogger LOG = CLoggerFactory.getLogger((String)"network.costs");
    private final Map<UUID, CCostEntry> mCosts = new HashMap<UUID, CCostEntry>();

    CCostList() {
    }

    void addCosts(@NotNull UUID aConnectionId, int aCosts, boolean aFix) {
        String action;
        CCostEntry entry = this.mCosts.get(aConnectionId);
        if (entry == null) {
            entry = new CCostEntry(aCosts, aFix);
            this.mCosts.put(aConnectionId, entry);
            action = "Add";
        } else {
            if (!entry.isFix()) {
                entry.setCosts(aCosts);
            }
            action = "Update";
        }
        LOG.debug("{} fixed costs: {} {}", new Object[]{action, aConnectionId, aCosts});
    }

    int getCosts(@NotNull UUID aConnectionId) {
        CCostEntry entry = this.mCosts.get(aConnectionId);
        return entry == null ? 1 : entry.getCosts();
    }

    Collection<CCostEntry> costs() {
        return this.mCosts.values();
    }

    void removeOldEntries(int aTimeoutInSeconds) {
        this.mCosts.values().removeIf(e -> e.canBeRemoved(aTimeoutInSeconds));
    }

    CRecord createBroadcastRecord() throws CException {
        int size = this.mCosts.size();
        UUID[] connectionIds = new UUID[size];
        int[] costs = new int[size];
        ZonedDateTime[] timestamps = new ZonedDateTime[size];
        int i = 0;
        for (Map.Entry<UUID, CCostEntry> entry : this.mCosts.entrySet()) {
            connectionIds[i] = entry.getKey();
            costs[i] = entry.getValue().getCosts();
            timestamps[i] = entry.getValue().getCostMeasureTime();
            ++i;
        }
        CRecord record = CRecordBroadcastLinkCosts.create();
        CRecordBroadcastLinkCosts.setConnectionIds((CRecord)record, (UUID[])connectionIds);
        CRecordBroadcastLinkCosts.setCosts((CRecord)record, (int[])costs);
        CRecordBroadcastLinkCosts.setTime((CRecord)record, (ZonedDateTime[])timestamps);
        return record;
    }

    int size() {
        return this.mCosts.size();
    }

    public void dump(@NotNull StringBuilder aSb) {
        for (Map.Entry<UUID, CCostEntry> entry : this.mCosts.entrySet()) {
            aSb.append(String.format("%s -- %d\n", entry.getKey(), entry.getValue().getCosts()));
        }
    }
}

