/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.webserver.ssl;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.impl.webserver.ssl.CWebServerSsl;
import de.sillysky.nyssr.impl.webserver.ssl.IDependencies;
import de.sillysky.nyssr.kernel.configuration.IKernelConfiguration;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.util.files.CUtilFile;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.prefs.Preferences;
import org.jetbrains.annotations.NotNull;

public class CWebServerSslFactory
implements IService {
    private final IDependencies mDependencies;
    private CWebServerSsl mWebServer;

    CWebServerSslFactory(@NotNull IDependencies aDependencies) {
        this.mDependencies = aDependencies;
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        Path keyStorePath;
        IKernelConfiguration kc = this.mDependencies.getKernelConfiguration();
        Preferences preferences = kc.getPreferences("webserver.ssl");
        int port = preferences.getInt("port", 8080);
        String webroot = preferences.get("webroot", "webroot");
        char[] password = preferences.get("password.keystore", "").toCharArray();
        Path storagePath = kc.getStoragePath();
        if (storagePath == null) {
            throw new CException(2202).append("No web root found");
        }
        Path path = Paths.get(webroot, new String[0]);
        if (!path.toFile().exists()) {
            path = storagePath.resolve(webroot);
            CUtilFile.createDirectories((Path)path);
            if (!path.toFile().exists()) {
                throw new CException(2202).append("Couldn't create web root ").append((Object)path);
            }
        }
        this.mWebServer = (keyStorePath = storagePath.resolve("webserver/keystore.jks")).toFile().exists() ? new CWebServerSsl(port, path, keyStorePath, password) : new CWebServerSsl(port, path, null, password);
        this.mWebServer.start();
        Arrays.fill(password, '\u0000');
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        this.mWebServer.stop();
        this.mWebServer = null;
    }
}

