/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.dialog.user;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.widget.CWidgetId;
import de.sillysky.nyssr.id.widget.CWidgetSetId;
import de.sillysky.nyssr.impl.dialog.user.CMainTarget;
import de.sillysky.nyssr.remoteskin.model.events.CEventButtonPressedNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventLabelItem;
import de.sillysky.nyssr.remoteskin.model.events.CEventListContent;
import de.sillysky.nyssr.remoteskin.model.events.CEventListSelectionNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventWindowNotification;
import de.sillysky.nyssr.remoteskin.server.context.IRemoteSkinServerContext;
import de.sillysky.nyssr.remoteskin.server.context.IWidgetApi;
import de.sillysky.nyssr.remoteskin.server.listeners.IButtonPressedListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IListSelectionListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IWindowClosingListener;
import de.sillysky.nyssr.session.api.CUser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class C702Handler {
    private final CMainTarget mMainTarget;
    private final IRemoteSkinServerContext mServerContext;
    private final IWidgetApi mApi;
    private final CWidgetSetId mWs702;
    private final CWidgetId m702Dialog;
    private final CWidgetId m702ListRoles;
    private final CWidgetId m702ButtonOkay;
    private final CWidgetId m702ButtonCancel;
    private final ArrayList<String> mSelectedRoles = new ArrayList();
    private boolean m702ButtonOkayIsEnabled;
    private boolean m702open;
    private CWidgetId mParentWidget;
    private CUser mUser;
    private Collection<String> mRoles;

    C702Handler(@NotNull CMainTarget aMainTarget, @NotNull IRemoteSkinServerContext aServerContext, @NotNull String aInstance) {
        this.mMainTarget = aMainTarget;
        this.mServerContext = aServerContext;
        this.mApi = this.mServerContext.getWidgetApi();
        this.mWs702 = CWidgetSetId.create((String)"@702_ChooseRoles", (String)aInstance);
        this.m702Dialog = CWidgetId.create((String)"#702_Dialog", (CWidgetSetId)this.mWs702);
        this.mApi.addListener(this.m702Dialog, (IListener)((IWindowClosingListener)this::onDialogClosing));
        this.m702ListRoles = CWidgetId.create((String)"#702_ListRoles", (CWidgetSetId)this.mWs702);
        this.mApi.addListener(this.m702ListRoles, (IListener)((IListSelectionListener)this::onListRoleSelection));
        this.m702ButtonOkay = CWidgetId.create((String)"#702_ButtonOkay", (CWidgetSetId)this.mWs702);
        this.mApi.addListener(this.m702ButtonOkay, (IListener)((IButtonPressedListener)this::onButtonOkay));
        this.m702ButtonCancel = CWidgetId.create((String)"#702_ButtonCancel", (CWidgetSetId)this.mWs702);
        this.mApi.addListener(this.m702ButtonCancel, (IListener)((IButtonPressedListener)this::onButtonCancel));
    }

    private void onDialogClosing(@NotNull CEventWindowNotification aWindowEvent) {
        this.unmount();
    }

    void mount(@NotNull CWidgetId aParentWidget, @NotNull CUser aUser, @NotNull Collection<String> aRoles) {
        if (!this.m702open) {
            this.m702open = true;
            this.mUser = new CUser(aUser);
            this.mRoles = aRoles;
            this.mParentWidget = aParentWidget;
            this.m702ButtonOkayIsEnabled = false;
            this.mServerContext.mountWidgetSet(this.mWs702, this.mParentWidget, "#702_PanelBackground", this::widgetSetMounted);
            this.sendUpdate();
        }
    }

    private void fillRoles(@NotNull Collection<String> aRoles) {
        CEventListContent event = new CEventListContent();
        for (String role : aRoles) {
            CEventLabelItem item = new CEventLabelItem(role);
            item.getAttributes().setValue((Object)role);
            event.add(item);
        }
        this.mApi.setListContent(this.m702ListRoles, event);
    }

    private void widgetSetMounted(@NotNull CWidgetSetId aWidgetSetId) {
        if (this.mWs702.equals((Object)aWidgetSetId)) {
            this.mApi.pack(this.m702Dialog);
            this.mApi.centerWidget(this.m702Dialog, this.mParentWidget);
            this.fillRoles(this.mRoles);
            this.mApi.setVisible(this.m702Dialog, true);
            this.sendUpdate();
        }
    }

    void unmount() {
        if (this.m702open) {
            this.m702open = false;
            this.mApi.unmount(this.m702Dialog);
            this.sendUpdate();
        }
    }

    private void sendUpdate() {
        this.mServerContext.sendUpdate();
    }

    private void onButtonOkay(@NotNull CEventButtonPressedNotification aEvent) throws CException {
        this.mMainTarget.sendAddRight(this.mUser.getId(), this.mSelectedRoles);
        this.unmount();
    }

    private void onButtonCancel(@NotNull CEventButtonPressedNotification aEvent) {
        this.unmount();
    }

    private void onListRoleSelection(@NotNull CEventListSelectionNotification aEvent) {
        this.mSelectedRoles.clear();
        List selectedIds = aEvent.getSelectedIds();
        this.mSelectedRoles.addAll(selectedIds);
        if (selectedIds.isEmpty() == this.m702ButtonOkayIsEnabled) {
            this.m702ButtonOkayIsEnabled = !this.m702ButtonOkayIsEnabled;
            this.mApi.setEnabled(this.m702ButtonOkay, this.m702ButtonOkayIsEnabled);
            this.sendUpdate();
        }
    }
}

