/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.app.widget.showcase;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.app.widget.showcase.CApplicationContext;
import de.sillysky.nyssr.impl.app.widget.showcase.IAppContext;
import de.sillysky.nyssr.impl.app.widget.showcase.IDependencies;
import de.sillysky.nyssr.impl.app.widget.showcase.main.CMainFrameTarget;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.message.panel.records.CRecordAddMessages;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.remoteskin.model.EPlatformType;
import de.sillysky.nyssr.remoteskin.server.connector.IRemoteSkinClientContext;
import de.sillysky.nyssr.remoteskin.server.context.IRemoteSkinServerContext;
import de.sillysky.nyssr.remoteskin.server.widgetset.loader.IWidgetSetLoader;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import java.util.ArrayList;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CApp
extends CTarget
implements IAppContext {
    private static final ILogger LOG = CLoggerFactory.getLogger(CApp.class);
    private static final String[] JSON_FILES_1 = new String[]{"/json/103_DlgMessageHistory.json", "/json/300_MainFrame.json", "/json/307_Basics.json"};
    private static final String[] JSON_FILES_2 = new String[]{"/json/301_Slider.json", "/json/302_Spinner.json", "/json/303_Table.json", "/json/304_Tree.json", "/json/304_10.json", "/json/304_11.json", "/json/305_Button.json", "/json/306_Border.json", "/json/308_Label.json", "/json/309_CheckBox.json", "/json/310_RadioButton.json", "/json/310_19.json", "/json/311_TextField.json", "/json/312_Dialogs.json", "/json/313_Toolbar.json", "/json/313_01_Toolbar.json", "/json/313_02_Toolbar.json", "/json/313_03_Toolbar.json", "/json/313_04_Toolbar.json", "/json/313_05_Toolbar.json", "/json/313_06_Toolbar.json", "/json/314_ProgressBar.json", "/json/315_Menu.json", "/json/315_01_Menu.json", "/json/315_02_Menu.json", "/json/315_03_Menu.json", "/json/315_04_Menu.json", "/json/315_05_Menu.json", "/json/315_06_Menu.json", "/json/315_07_Menu.json", "/json/315_08_Menu.json", "/json/315_09_Menu.json", "/json/315_10_Menu.json", "/json/315_11_Menu.json", "/json/315_12_Menu.json", "/json/315_13_Menu.json", "/json/316_ListBox.json", "/json/317_ComboBox.json", "/json/399_Row.json"};
    private IId mContextId = CIdFactory.fromObject((Object)("WidgetShowcase_" + String.valueOf(UUID.randomUUID())));
    private CApplicationContext mContext;
    private CMainFrameTarget mTargetMainFrame;
    private IRemoteSkinServerContext mRemoteSkinServerContext;
    private IDependencies mDependencies;
    private boolean mOtherWidgetSetsTransferred = false;
    private CTargetAddress mMessagePanelAddress;

    void activate(@NotNull IDependencies aDependencies, @NotNull CApplicationContext aContext) throws CException {
        this.mDependencies = aDependencies;
        this.mContext = aContext;
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        INamespace ns = aContext.getNamespace();
        CUtilCheck.checkNotNull((Object)ns, (String)"Namespace is null", (Object[])new Object[0]);
        ns.getTargetRegistry().registerTarget((ITarget)this);
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        CNodeAddress remoteSkinClient = this.mContext.getClientRemoteSkinAddress();
        INamespace ns = this.mContext.getNamespace();
        if (remoteSkinClient != null && ns != null) {
            this.mRemoteSkinServerContext = this.mDependencies.getRemoteSkinServerContextFactory().createContext(ns.getNID());
            this.mRemoteSkinServerContext.startContext(this.mContextId, remoteSkinClient, EPlatformType.SWING.name(), this::notifyClientContextStarted);
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    @Override
    public void closeContext() {
        if (this.mContextId != null) {
            this.mContextId = null;
        }
    }

    @Override
    public CApplicationContext getApplicationContext() {
        return this.mContext;
    }

    @Override
    public IRemoteSkinClientContext getRemoteSkinClientContext() {
        return this.mRemoteSkinServerContext.getClientContext();
    }

    @Override
    public IRemoteSkinServerContext getRemoteSkinServerContext() {
        return this.mRemoteSkinServerContext;
    }

    private void sendJsonFiles() {
        this.sendWidgetSets("first Files", JSON_FILES_1);
    }

    @Override
    public void sendOtherWidgetSets() {
        if (!this.mOtherWidgetSetsTransferred) {
            this.mOtherWidgetSetsTransferred = true;
            this.sendWidgetSets("other WidgetSets", JSON_FILES_2);
        }
    }

    private void sendWidgetSets(@NotNull String aActionName, @NotNull String[] aFileNameArray) {
        try {
            ArrayList<String> jsonList = new ArrayList<String>();
            IWidgetSetLoader loader = this.mDependencies.getWidgetSetLoader();
            for (String f : aFileNameArray) {
                String json = loader.loadJson(this.getClass(), f);
                jsonList.add(json);
            }
            this.mRemoteSkinServerContext.pushWidgetSets(jsonList, null);
        }
        catch (CException aE) {
            LOG.error((Throwable)aE, "Error sending {}", new Object[]{aActionName});
        }
    }

    private void notifyClientContextStarted(@NotNull IRemoteSkinClientContext aRemoteSkinClientContext, int aResultCode, @Nullable String aResultText) throws CException {
        if (aResultCode == 0) {
            this.sendJsonFiles();
            this.mTargetMainFrame = new CMainFrameTarget(this);
            this.getTargetRegistry().registerTarget((ITarget)this.mTargetMainFrame);
        }
    }

    @Override
    public void addMessage(@NotNull String aText) {
        if (this.mMessagePanelAddress != null) {
            try {
                CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)this.mMessagePanelAddress);
                CRecord rec = CRecordAddMessages.create();
                CRecordAddMessages.setMessages((CRecord)rec, (String[])new String[]{aText});
                this.sendNotification(env, rec);
            }
            catch (CException aE) {
                LOG.error("Couldn't send Message {}", new Object[]{aText});
            }
        }
    }

    @Override
    public CTargetAddress getMessagePanelAddress() {
        return this.mMessagePanelAddress;
    }

    @Override
    public void setMessagePanelAddress(@Nullable CTargetAddress aAddress) {
        this.mMessagePanelAddress = aAddress;
    }
}

