/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table;

import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table.CColumn;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table.CTable;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table.CTableModel;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table.CVisibleIds;
import de.sillysky.nyssr.remoteskin.model.enums.EColumnType;
import de.sillysky.nyssr.remoteskin.model.events.CEventFont;
import de.sillysky.nyssr.remoteskin.model.events.CEventTableColumn;
import de.sillysky.nyssr.remoteskin.model.events.border.IBorder;
import java.awt.Color;
import java.awt.Font;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CColumnModel {
    private static final long serialVersionUID = 346187071772512479L;
    private final CTableModel mTableModel;
    private final Map<String, CColumn> mColumns = new HashMap<String, CColumn>();
    private final CVisibleIds mColumnIndex = new CVisibleIds();
    private final DefaultTableColumnModel mSwingModel = new DefaultTableColumnModel();

    public CColumnModel(@NotNull CTableModel aTableModel) {
        this.mTableModel = aTableModel;
        this.getTable().setColumnModel(this.mSwingModel);
    }

    DefaultTableColumnModel getSwingColumnModel() {
        return this.mSwingModel;
    }

    private void removeAllColumns() {
        while (this.mSwingModel.getColumnCount() != 0) {
            TableColumn column = this.mSwingModel.getColumn(0);
            this.mSwingModel.removeColumn(column);
        }
        this.mColumns.clear();
        this.mColumnIndex.clear();
    }

    void addColumn(@NotNull CEventTableColumn aEvent) {
        String id = aEvent.getId();
        CColumn column = this.getOrAddColumn(id);
        this.alterColumn(column, aEvent);
    }

    boolean alterColumn(@NotNull CEventTableColumn aEvent) {
        String id = aEvent.getId();
        CColumn column = this.getColumn(id);
        if (column != null) {
            this.alterColumn(column, aEvent);
            return true;
        }
        return false;
    }

    void alterColumn(@NotNull CColumn aColumn, @NotNull CEventTableColumn aEvent) {
        Boolean sizeWidthToFit;
        Font font2;
        CEventFont font1;
        Border border2;
        IBorder border1;
        int preferredWidth;
        int maximumWidth;
        int minimumWidth;
        String format;
        EColumnType type;
        Color headerForeground;
        Color headerBackground;
        Boolean resizable;
        Boolean isEditable = aEvent.isColumnCellsEditable();
        if (isEditable != null) {
            aColumn.setEditable(isEditable);
        }
        if ((resizable = aEvent.isResizable()) != null) {
            aColumn.setResizable(resizable);
        }
        if ((headerBackground = aEvent.getBackground()) != null) {
            aColumn.setBackground(headerBackground);
        }
        if ((headerForeground = aEvent.getForeground()) != null) {
            aColumn.setForeground(headerForeground);
        }
        if ((type = aEvent.getType()) != null) {
            aColumn.setType(type);
        }
        if ((format = aEvent.getFormat()) != null) {
            aColumn.setFormat(format);
        }
        if ((minimumWidth = aEvent.getMinimumColumnWidth()) >= 0) {
            aColumn.setMinWidth(minimumWidth);
        }
        if ((maximumWidth = aEvent.getMaximumColumnWidth()) >= 0) {
            aColumn.setMaxWidth(maximumWidth);
        }
        if ((preferredWidth = aEvent.getPreferredColumnWidth()) >= 0) {
            aColumn.setPreferredWidth(preferredWidth);
        }
        if ((border1 = aEvent.getBorder()) != null && (border2 = border1.createBorder()) != null) {
            aColumn.setBorder(border2);
        }
        if ((font1 = aEvent.getFont()) != null && (font2 = font1.createFont()) != null) {
            aColumn.setFont(font2);
        }
        if ((sizeWidthToFit = aEvent.isWidthToFit()) != null) {
            aColumn.setSizeWidthToFit(sizeWidthToFit);
        }
    }

    void setColumns(@NotNull List<CEventTableColumn> aColumns) {
        this.removeAllColumns();
        for (CEventTableColumn c : aColumns) {
            this.addColumn(c);
        }
    }

    CColumn getColumn(@NotNull String aColumnId) {
        return this.mColumns.get(aColumnId);
    }

    @Nullable
    CColumn getColumnByIndex(int aIndex) {
        String id;
        if (aIndex >= 0 && aIndex < this.mColumnIndex.size() && (id = this.mColumnIndex.getByIndex(aIndex)) != null) {
            return this.mColumns.get(id);
        }
        return null;
    }

    int getColumnIndex(@NotNull String aColumnId) {
        return this.mColumnIndex.getIndex(aColumnId);
    }

    void setColumnType(@NotNull String aColumnId, @NotNull EColumnType aType) {
        CColumn column = this.getColumn(aColumnId);
        if (column != null) {
            column.setType(aType);
        }
    }

    public void finish() {
        boolean ix = false;
        for (String id : this.mColumnIndex.ids()) {
            CColumn column = this.mColumns.get(id);
            assert (column != null);
            column.finish();
        }
    }

    @NotNull
    public CColumn getOrAddColumn(@NotNull String aColumnId) {
        CColumn column = this.mColumns.get(aColumnId);
        if (column == null) {
            column = this.addColumn(aColumnId);
        }
        return column;
    }

    private CColumn addColumn(@NotNull String aColumnId) {
        CColumn column = new CColumn(this, aColumnId, this.mColumnIndex.size());
        this.mColumns.put(aColumnId, column);
        this.mColumnIndex.addId(aColumnId);
        return column;
    }

    public int size() {
        return this.mColumnIndex.size();
    }

    CTableModel getTableModel() {
        return this.mTableModel;
    }

    CTable getTable() {
        return this.mTableModel.getTable();
    }
}

