/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.file.store.service;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.file.store.records.CRecordFileStoreFile;
import de.sillysky.nyssr.record.CRecord;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import org.jetbrains.annotations.NotNull;

public class CFileDto {
    private String mRelativePath;
    private long mLength;
    private FileTime mTimeOfCreation;
    private FileTime mTimeOfLastModification;
    private String mHash;

    @NotNull
    public static CFileDto fromRecord(@NotNull CRecord aRecord) throws CException {
        if (!CRecordFileStoreFile.ID.equals((Object)aRecord.getId())) {
            throw new CException(2010).append("Wrong record type.");
        }
        CFileDto dto = new CFileDto();
        String path = CRecordFileStoreFile.getPath((CRecord)aRecord, null);
        dto.setRelativePath(path);
        String hash = CRecordFileStoreFile.getHash((CRecord)aRecord, null);
        dto.setHash(hash);
        long fileLength = CRecordFileStoreFile.getFileLength((CRecord)aRecord, (long)-1L);
        dto.setLength(fileLength);
        Instant creationTime = CRecordFileStoreFile.getTimeOfCreation((CRecord)aRecord, null);
        dto.setTimeOfCreation(creationTime == null ? null : FileTime.from(creationTime));
        Instant modifiedTime = CRecordFileStoreFile.getTimeOfLastModification((CRecord)aRecord, null);
        dto.setTimeOfLastModification(modifiedTime == null ? null : FileTime.from(modifiedTime));
        return dto;
    }

    public String getRelativePath() {
        return this.mRelativePath;
    }

    public void setRelativePath(String aRelativePath) {
        this.mRelativePath = aRelativePath;
    }

    public long getLength() {
        return this.mLength;
    }

    public void setLength(long aLength) {
        this.mLength = aLength;
    }

    public FileTime getTimeOfCreation() {
        return this.mTimeOfCreation;
    }

    public void setTimeOfCreation(FileTime aTimeOfCreation) {
        this.mTimeOfCreation = aTimeOfCreation;
    }

    public FileTime getTimeOfLastModification() {
        return this.mTimeOfLastModification;
    }

    public void setTimeOfLastModification(FileTime aTimeOfLastModification) {
        this.mTimeOfLastModification = aTimeOfLastModification;
    }

    public String getHash() {
        return this.mHash;
    }

    public void setHash(String aHash) {
        this.mHash = aHash;
    }

    public String toString() {
        return "[path=" + this.mRelativePath + ",hash=" + this.mHash + ",length=" + this.mLength + ",created=" + String.valueOf(this.mTimeOfCreation) + ",modified=" + String.valueOf(this.mTimeOfLastModification) + "]";
    }
}

