/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.software.updater.local;

import de.sillysky.nyssr.address.CNodeId;
import de.sillysky.nyssr.impl.plugin.CUtilPlugIn;
import de.sillysky.nyssr.impl.software.updater.local.IDependencies;
import de.sillysky.nyssr.json.CJsonArray;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.util.hash.CMd5;
import de.sillysky.nyssr.util.hash.CUtilMd5;
import de.sillysky.nyssr.util.string.builder.CStringBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

class CUtilVersionStringBuilder {
    private CUtilVersionStringBuilder() {
    }

    @NotNull
    static String getVersion(@NotNull IDependencies aDependencies, byte[] aSessionToken) throws IOException {
        CJsonObject root = new CJsonObject();
        CJsonObject json = new CJsonObject();
        root.put("jar_list", (Object)json);
        CJsonArray nodes = new CJsonArray();
        nodes.add((Object)CNodeId.getLocal().toString());
        json.put("nodes", (Object)nodes);
        json.put("reboot", (Object)true);
        json.put("sessionToken", aSessionToken == null ? "" : (Object)aSessionToken);
        json.put("libraries", (Object)CUtilVersionStringBuilder.getLibraryList(aDependencies));
        json.put("plugins", (Object)CUtilVersionStringBuilder.getPluginList(aDependencies));
        json.put("pluginsToLoad", (Object)CUtilVersionStringBuilder.getLoadedPlugins());
        CStringBuilder sb = new CStringBuilder();
        aDependencies.getJsonWriter().beautify(sb, (Object)root);
        return sb.toString();
    }

    @NotNull
    private static CJsonArray getLoadedPlugins() {
        List pluginList = CUtilPlugIn.loadPluginListFromPreferencesSubNode();
        return new CJsonArray((Collection)pluginList);
    }

    @NotNull
    private static CJsonArray getLibraryList(@NotNull IDependencies aDependencies) throws IOException {
        return CUtilVersionStringBuilder.getFileList(aDependencies, "path.libs", true);
    }

    @NotNull
    private static CJsonArray getPluginList(@NotNull IDependencies aDependencies) throws IOException {
        return CUtilVersionStringBuilder.getFileList(aDependencies, "path.plugins", true);
    }

    @NotNull
    private static CJsonArray getFileList(@NotNull IDependencies aDependencies, @NotNull String aKey, boolean aWithHash) throws IOException {
        CJsonArray arr = new CJsonArray();
        String s = aDependencies.getNodeStringProperties().get(aKey);
        if (s != null) {
            Path path = Paths.get(s, new String[0]);
            try (Stream<Path> list = Files.list(path);){
                list.forEach(aPath -> {
                    CMd5 md5;
                    Object ss = aPath.getFileName().toString();
                    if (aWithHash && (md5 = CUtilMd5.calculate((File)aPath.toFile(), null)) != null) {
                        String hash = md5.toBase32();
                        ss = (String)ss + "(" + hash + ")";
                    }
                    arr.add(ss);
                });
            }
        }
        return arr;
    }
}

