/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.software.updater.local;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.address.CNodeId;
import de.sillysky.nyssr.address.CSegmentId;
import de.sillysky.nyssr.cli.records.CRecordCliHandle;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.impl.software.updater.local.CUtilReboot;
import de.sillysky.nyssr.impl.software.updater.local.IDependencies;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.network.nodeinfo.CNodeInfo;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.session.verifier.CSessionData;
import de.sillysky.nyssr.software.updater.records.CRecordReboot;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.util.cmdline.CSimpleArgParser;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CTargetRebootNode
extends CTarget {
    private static final ILogger LOG = CLoggerFactory.getLogger(CTargetRebootNode.class);
    private static final String RIGHT_SHUTDOWN = "NY_Shutdown";
    private final IDependencies mDependencies;
    private final CEnvelope mEnvelope;
    private final CRecord mRecord;
    private ScheduledExecutorService mScheduler;

    CTargetRebootNode(@NotNull IDependencies aDependencies, @NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        this.mDependencies = aDependencies;
        this.mEnvelope = aEnvelope;
        this.mRecord = aRecord;
        this.mEnvelope.setBlocked(true);
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        byte[] sessionToken = this.mEnvelope.getSessionToken();
        if (this.validate(sessionToken)) {
            this.rebootNode(sessionToken);
        } else {
            this.deregisterTarget();
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private void rebootNode(byte[] aSessionToken) throws CException {
        if (CRecordReboot.ID.equals((Object)this.mRecord.getId())) {
            ZonedDateTime time = CRecordReboot.getTime((CRecord)this.mRecord, null);
            int code = CRecordReboot.getCode((CRecord)this.mRecord, (int)0);
            this.doReboot(time == null ? null : time.toInstant(), code);
        } else if (CRecordCliHandle.ID.equals((Object)this.mRecord.getId())) {
            boolean segment;
            String in;
            Instant time = null;
            String[] arguments = CRecordCliHandle.getArguments((CRecord)this.mRecord, null);
            if (arguments == null || arguments.length == 0) {
                this.doReboot(null, 1);
                return;
            }
            CSimpleArgParser p = new CSimpleArgParser(arguments);
            String at = p.getOption("at");
            if (at != null) {
                time = CTargetRebootNode.convertStringToInstant(at);
            }
            if ((in = p.getOption("in")) != null) {
                int seconds = Integer.parseInt(in);
                time = Instant.now().plus((long)seconds, ChronoUnit.SECONDS);
            }
            if (segment = p.hasFlag("s")) {
                Collection reachableNodes = this.mDependencies.getRouter().getReachableNodes();
                if (time == null) {
                    time = Instant.now().plus(3L, ChronoUnit.SECONDS);
                }
                for (CNodeInfo nodeInfo : reachableNodes) {
                    CNodeAddress nodeAddress = nodeInfo.getNodeAddress();
                    if (!nodeAddress.getSegmentId().isLocal()) continue;
                    this.sendReboot(nodeAddress, aSessionToken, time, 1);
                }
                this.finish(0, "");
            } else {
                String nodes = p.getOption("nodes");
                if (nodes == null) {
                    if (time == null) {
                        time = Instant.now();
                    }
                    this.finish(0, "");
                    this.doReboot(time, 1);
                } else {
                    String[] nodeArray;
                    for (String nodeName : nodeArray = nodes.split(",")) {
                        CNodeId nodeId = new CNodeId(nodeName.trim());
                        CNodeAddress nodeAddress = new CNodeAddress(nodeId, CSegmentId.getLocal());
                        if (time == null) {
                            time = Instant.now();
                        }
                        this.sendReboot(nodeAddress, aSessionToken, time, 1);
                    }
                    this.finish(0, "");
                }
            }
        }
    }

    private void doReboot(@Nullable Instant aTime, int aCode) throws CException {
        CUtilReboot.sendAnnounceReboot((ITarget)this, aTime);
        if (aTime == null || aTime.isBefore(Instant.now())) {
            LOG.info("reboot now");
            System.out.println("reboot now");
            System.exit(aCode);
        } else {
            LOG.info("reboot at {}", new Object[]{aTime});
            System.out.println("reboot at " + String.valueOf(aTime));
            this.mScheduler = Executors.newScheduledThreadPool(1);
            long delay = Duration.between(Instant.now(), aTime).toMillis();
            this.mScheduler.schedule(() -> System.exit(aCode), delay, TimeUnit.MILLISECONDS);
            this.mScheduler.shutdown();
        }
    }

    private void sendReboot(@NotNull CNodeAddress aNodeAddress, byte[] aSessionToken, @NotNull Instant aTime, int aExitCode) throws CException {
        CEnvelope env = CEnvelope.forRemoteNanoService(CRecordReboot.class, (CNodeAddress)aNodeAddress);
        env.setSessionToken(aSessionToken);
        CRecord record = CRecordReboot.create();
        ZonedDateTime time = aTime.atZone(ZoneId.systemDefault());
        CRecordReboot.setTime((CRecord)record, (ZonedDateTime)time);
        CRecordReboot.setCode((CRecord)record, (int)aExitCode);
        LOG.info("sending reboot to {} at {}", new Object[]{aNodeAddress, time});
        this.sendNotification(env, record);
    }

    private boolean checkRights(String[] aRights) {
        if (aRights != null) {
            for (String right : aRights) {
                if (!right.equalsIgnoreCase(RIGHT_SHUTDOWN)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean validate(byte[] aSessionToken) throws CException {
        CSessionData sessionData = this.mDependencies.getSessionVerifier().verifyRequest(aSessionToken, (ITarget)this, this.mEnvelope, this.mRecord);
        if (sessionData != null) {
            boolean b = this.checkRights(sessionData.getRightIds());
            if (!b) {
                this.finish(5105, "Missing right.");
                return false;
            }
            return true;
        }
        if (this.mEnvelope.isBlocked()) {
            return false;
        }
        return false;
    }

    public static Instant convertStringToInstant(@NotNull String aTimeString) {
        LocalTime time = LocalTime.parse(aTimeString);
        LocalDate today = LocalDate.now();
        LocalTime now = LocalTime.now();
        LocalDateTime dateTime = now.isAfter(time) ? LocalDateTime.of(today.plusDays(1L), time) : LocalDateTime.of(today, time);
        return dateTime.atZone(ZoneId.systemDefault()).toInstant();
    }

    private void finish(int aCode, String aText) throws CException {
        this.mEnvelope.setResult(aCode, aText);
        this.mEnvelope.setBlocked(false);
        this.getMessageSender().sendBack(this.mEnvelope, this.mRecord);
        this.deregisterTarget();
        System.out.println("finish " + aCode);
    }
}

