/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.transport;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.impl.network.transport.CTransport;
import de.sillysky.nyssr.impl.network.transport.IDependencies;
import de.sillysky.nyssr.impl.network.transport.ITransport;
import de.sillysky.nyssr.impl.network.transport.ITransportFactory;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.network.connection.dto.CConnectionDto;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.target.ITarget;
import org.jetbrains.annotations.NotNull;

class CTransportFactory
implements IService,
ITransportFactory {
    private static final ILogger LOG = CLoggerFactory.getLogger(CTransportFactory.class);
    private static final String TRANSPORT = "Transport";
    @NotNull
    private final IDependencies mDependencies;

    CTransportFactory(@NotNull IDependencies aDependencies) {
        this.mDependencies = aDependencies;
    }

    @Override
    public ITransport createTransport(@NotNull CTargetAddress aOwner, @NotNull CConnectionDto aConnection) throws CException {
        LOG.debug("Create Transport");
        CTransport t = new CTransport(this.mDependencies);
        t.activate(aOwner, aConnection);
        IId nid = CIdFactory.random((String)TRANSPORT);
        INamespace ns = this.mDependencies.getNamespaceFactory().createAndRegisterNamespace(nid, TRANSPORT);
        ns.getTargetRegistry().registerTarget((ITarget)t);
        LOG.debug("Transport target registered as {}", new Object[]{t.getAddress()});
        return t;
    }

    @Override
    public void deleteTransport(@NotNull ITransport aTransport) throws CException {
        CTargetAddress address = aTransport.getAddress();
        IId nid = address.getNID();
        ((CTransport)aTransport).deactivate();
        this.mDependencies.getNamespaceFactory().deleteNamespace(nid);
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        aServiceRegistry.registerService(ITransportFactory.class, (Object)this);
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        aServiceRegistry.deregisterService((Object)this);
    }
}

