/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.transport;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.address.filter.CTargetAddressFilter;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.common.CWellKnownTID;
import de.sillysky.nyssr.impl.network.bridgehead.CBridgeHeadTarget;
import de.sillysky.nyssr.impl.network.connection.registry.records.CRecordNotifyConnectionClosed;
import de.sillysky.nyssr.impl.network.ping.ITargetLinkCosts;
import de.sillysky.nyssr.impl.network.records.CRecordTimerForForwardStats;
import de.sillysky.nyssr.impl.network.transport.CConstants;
import de.sillysky.nyssr.impl.network.transport.CTransportInputHandler;
import de.sillysky.nyssr.impl.network.transport.CTransportOutputHandler;
import de.sillysky.nyssr.impl.network.transport.IDependencies;
import de.sillysky.nyssr.impl.network.transport.IPrivateTransport;
import de.sillysky.nyssr.impl.network.transport.ITransport;
import de.sillysky.nyssr.kernel.configuration.ETypeOfNode;
import de.sillysky.nyssr.kernel.records.CRecordDismiss;
import de.sillysky.nyssr.link.collector.records.CRecordLinkCollectorAddLink;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.message.CMessage;
import de.sillysky.nyssr.message.CRoutingHint;
import de.sillysky.nyssr.message.IMessageSender;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.network.connection.dto.CConnectionDto;
import de.sillysky.nyssr.network.packets.IPacket;
import de.sillysky.nyssr.network.packets.IPacketConsumerRegistry;
import de.sillysky.nyssr.network.packets.IPacketFactoryRegistry;
import de.sillysky.nyssr.network.packets.IPacketMessage;
import de.sillysky.nyssr.network.records.CRecordNetworkDataForRemote;
import de.sillysky.nyssr.network.records.CRecordNetworkDataFromRemote;
import de.sillysky.nyssr.network.records.CRecordNetworkIncomingMessage;
import de.sillysky.nyssr.network.records.CRecordNetworkRoutePacket;
import de.sillysky.nyssr.network.records.CRecordNetworkSendToRemote;
import de.sillysky.nyssr.network.transport.records.CRecordConnectionStartReceiving;
import de.sillysky.nyssr.network.transport.records.CRecordServiceNotifyTransportClosed;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.monitor.records.CRecordTargetMonitorNotifyTargetDeregistered;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.util.CUtilByteArray;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CTransport
extends CTarget
implements IPrivateTransport,
ITransport {
    private static final ILogger LOG_MSG = CLoggerFactory.getLogger((String)"MessageTransport");
    private static final ILogger LOG = CLoggerFactory.getLogger(CTransport.class);
    private static final ILogger LOG_FORWARD = CLoggerFactory.getLogger((String)"network.forward");
    private static final long TIMEOUT_FORWARD_STATS = 30000L;
    @NotNull
    private final IDependencies mDependencies;
    private CTargetAddress mOwner;
    private CConnectionDto mConnection;
    private CTransportInputHandler mInputHandler;
    private CTransportOutputHandler mOutputHandler;
    private long mPacketsForwarded = 0L;
    private long mBytesForwarded = 0L;
    private long mBytesForwardedReported = 0L;
    private ITargetLinkCosts mTargetLinkCosts;
    private CBridgeHeadTarget mBridgeHead;
    private boolean mConnectionClosed = false;

    CTransport(@NotNull IDependencies aDependencies) {
        this.mDependencies = aDependencies;
    }

    void activate(@NotNull CTargetAddress aOwner, @NotNull CConnectionDto aConnection) {
        this.mOwner = aOwner;
        this.mConnection = aConnection;
        LOG.debug("Activate {} {}", new Object[]{this.getClass().getSimpleName(), System.identityHashCode(this)});
        this.mOutputHandler = new CTransportOutputHandler(this.mDependencies, this);
        this.mInputHandler = new CTransportInputHandler(this);
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordTargetMonitorNotifyTargetDeregistered.ID, this::asyncMonitorNotifyTargetRemoved);
        this.addMessageHandler(CRecordNetworkDataFromRemote.ID, this::asyncDataFromRemote);
        this.addMessageHandler(CRecordNetworkDataForRemote.ID, this::asyncDataForRemote);
        this.addMessageHandler(CRecordNetworkSendToRemote.ID, this::asyncSendToRemote);
        this.addMessageHandler(CRecordNetworkRoutePacket.ID, this::asyncRoutePacket);
        this.addMessageHandler(CRecordTimerForForwardStats.ID, this::asyncTimerForForwardStats);
    }

    void deactivate() {
        LOG.debug("Deregister Transport {}", new Object[]{this.getAddress()});
        this.deregisterTarget();
        if (this.mBridgeHead != null) {
            this.mBridgeHead.deregisterTarget();
            this.mBridgeHead = null;
        }
        if (this.mTargetLinkCosts != null) {
            this.mTargetLinkCosts.dismiss();
            this.mTargetLinkCosts = null;
        }
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        CTargetAddress address = this.getAddress();
        this.mDependencies.getNameDb().getTargetAddressDatabase().putName(address, "TransportTarget");
        LOG.debug("Initialize Transport, aConnection = {}", new Object[]{this.mConnection.toString()});
        this.mBridgeHead = new CBridgeHeadTarget(this, this.mDependencies.getMicroServiceRegistryCollector(), this.mDependencies.getNodeInfoDatabase());
        this.getTargetRegistry().registerTarget((ITarget)this.mBridgeHead);
        this.sendStartReceiving();
        CTargetAddress connectionAddress = this.mConnection.getConnectionAddress();
        if (connectionAddress != null) {
            IId nid = this.mConnection.getConnectionAddress().getNID();
            INamespace namespace = this.mDependencies.getNamespaceFactory().createAndRegisterNamespace(nid, "");
            namespace.getTargetRegistry().getMonitor().addObserver(this.getAddress(), new CTargetAddressFilter(this.mConnection.getConnectionAddress()));
        }
        this.startTimerForwardStats();
        this.mTargetLinkCosts = this.mDependencies.getLinkCostTargetFactory().createTarget(this);
        CNodeAddress rna = this.mConnection.getRemoteNodeAddress();
        if (rna != null) {
            this.mDependencies.getRouter().addDirectLink(this.mConnection.getID(), rna);
        }
        CNodeAddress remoteNodeAddress = this.mConnection.getRemoteNodeAddress();
        CUtilCheck.checkNotNull((Object)remoteNodeAddress, (String)"remoteAddress is null", (Object[])new Object[0]);
        this.sendAddLinkToLinkCollector(remoteNodeAddress);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncDataForRemote(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            int resultCode = aEnvelope.getResultCode();
            if (resultCode == 5201) {
                this.sendConnectionClosed(this.mConnection.getID());
            } else {
                this.mOutputHandler.notifySendDone();
            }
            return true;
        }
        return false;
    }

    private boolean asyncDataFromRemote(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        byte[] data = CRecordNetworkDataFromRemote.getData((CRecord)aRecord, null);
        try {
            this.mInputHandler.addIncomingData(data);
            aEnvelope.setResultSuccess();
        }
        catch (Exception e) {
            LOG.error((Throwable)e, "Exception on processing incoming data: ");
            aEnvelope.setResult(2, e.getMessage());
        }
        return true;
    }

    private boolean asyncMonitorNotifyTargetRemoved(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        UUID id = this.mConnection.getID();
        this.sendNotifyTransportClosed(id);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncRoutePacket(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (!aEnvelope.isAnswer()) {
            Object obj = CRecordNetworkRoutePacket.getPacket((CRecord)aRecord, null);
            if (obj instanceof IPacketMessage) {
                IPacketMessage pm = (IPacketMessage)obj;
                CNodeAddress source = pm.getSource();
                CNodeAddress local = this.getAddress().getNodeAddress();
                if (!local.equals((Object)source)) {
                    pm.addHop(local);
                }
                pm.pack();
                this.mBytesForwarded += (long)pm.getPayload().length;
                ++this.mPacketsForwarded;
                this.mOutputHandler.storePacketInQueue(pm);
            }
            aEnvelope.setResultSuccess();
            return true;
        }
        return false;
    }

    private boolean asyncSendToRemote(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CMessage message = CRecordNetworkSendToRemote.getMessage((CRecord)aRecord, null);
        CEnvelope envelope = message.getEnvelope();
        if (envelope.isOnlyLocal()) {
            aEnvelope.setResult(2005, "Msg only local");
        } else {
            LOG.debug("Route Message {} to {} ({})", new Object[]{message.getRecord().getId(), envelope.getReceiver(), this.getAddress()});
            if (ETypeOfNode.CLIENT.equals((Object)this.mDependencies.getKernelConfiguration().getTypeOfNode())) {
                envelope.setRoutingHint(new CRoutingHint(this.getAddress().getNodeAddress(), this.getRemoteNode().getNodeId()));
            }
            try {
                LOG_MSG.trace("Transport: Send Msg {}", new Object[]{envelope.getInstanceId()});
                this.mOutputHandler.prepareMessage(message);
                aEnvelope.setResultSuccess();
            }
            catch (CException e) {
                LOG.error((Throwable)e, "Exception during SendToRemote: ");
                aEnvelope.setResult(e.getError());
            }
        }
        return true;
    }

    private boolean asyncTimerForForwardStats(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (this.mBytesForwardedReported != this.mBytesForwarded) {
            this.mBytesForwardedReported = this.mBytesForwarded;
            LOG_FORWARD.debug("Statistics of forwarded Items to {}: {} packets, {} bytes", new Object[]{this.mConnection.getRemoteNodeAddress(), this.mPacketsForwarded, this.mBytesForwardedReported});
        }
        this.startTimerForwardStats();
        aEnvelope.setResultSuccess();
        return true;
    }

    @Override
    public boolean canSendMessage(@NotNull CMessage aMessage) throws CException {
        return this.mDependencies.getRouter().canSendMessage(aMessage);
    }

    @Override
    public void forwardPacketToOtherTransport(@NotNull IPacketMessage aPacket) {
        CNodeAddress destination = aPacket.getDestination();
        try {
            this.sendRoutePacket(destination, aPacket);
        }
        catch (CException e) {
            LOG.error((Throwable)e, "Exception on routing a packet to {}", new Object[]{destination});
        }
    }

    @Override
    @NotNull
    public IMessageSender getCentralSender() {
        return this.mDependencies.getMessageSender();
    }

    @Override
    public UUID getInstanceId() {
        return this.mDependencies.getKernelConfiguration().getInstanceId();
    }

    @Override
    public CNodeAddress getLocalNode() {
        return this.mDependencies.getMessageSender().getNodeAddress();
    }

    @Override
    @NotNull
    public UUID getConnectionId() {
        return this.mConnection.getID();
    }

    @Override
    @NotNull
    public IPacketConsumerRegistry getPacketConsumerRegistry() {
        return this.mDependencies.getPacketConsumerRegistry();
    }

    @Override
    @NotNull
    public IPacketFactoryRegistry getPacketFactoryRegistry() {
        return this.mDependencies.getPacketFactoryRegistry();
    }

    @Override
    @Nullable
    public CTargetAddress getPingTargetAddress() {
        return this.mTargetLinkCosts == null ? null : this.mTargetLinkCosts.getAddress();
    }

    @Override
    public CNodeAddress getRemoteNode() {
        return this.mConnection.getRemoteNodeAddress();
    }

    @Override
    public ITarget getTarget() {
        return this;
    }

    private void sendDataForRemote(byte[] aPayload, boolean aAsRequest) throws CException {
        if (this.mConnection != null) {
            CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)this.mConnection.getConnectionAddress());
            env.setLogEnabled(false);
            CRecord rec = CRecordNetworkDataForRemote.create();
            CRecordNetworkDataForRemote.setData((CRecord)rec, (byte[])aPayload);
            if (aAsRequest) {
                this.sendRequest(env, rec);
            } else {
                this.sendNotification(env, rec);
            }
        }
    }

    @Override
    public void sendDismissToConnection() throws CException {
        CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)this.mConnection.getConnectionAddress());
        CRecord rec = CRecordDismiss.create();
        this.sendNotification(env, rec);
    }

    private void sendNotifyTransportClosed(@NotNull UUID aConnectionID) throws CException {
        CEnvelope env = CEnvelope.forLocalNanoService(CRecordServiceNotifyTransportClosed.class);
        CRecord rec = CRecordServiceNotifyTransportClosed.create();
        CRecordServiceNotifyTransportClosed.setConnectionId((CRecord)rec, (UUID)aConnectionID);
        this.sendNotification(env, rec);
    }

    @Override
    public void sendPacketToTransportLayer(@NotNull IPacket aPackedData, boolean aAsRequest) throws CException {
        if (this.mConnectionClosed) {
            throw new CException(5601).append("Connection closed.");
        }
        byte[] payload = aPackedData.getPayload();
        if (CConstants.BYTE_LOG.isTraceEnabled()) {
            String string = CUtilByteArray.toString((byte[])payload, (char)',', (int)0);
            CConstants.BYTE_LOG.trace("Outgoing {} bytes: {}", new Object[]{payload.length, string});
        }
        this.sendDataForRemote(payload, aAsRequest);
    }

    private void sendRoutePacket(@NotNull CNodeAddress aDestination, @NotNull IPacketMessage aPacket) throws CException {
        CEnvelope env = CEnvelope.forLocalNanoService(CRecordNetworkRoutePacket.class);
        env.setLogEnabled(false);
        CRecord rec = CRecordNetworkRoutePacket.create();
        CRecordNetworkRoutePacket.setDestinationNode((CRecord)rec, (CNodeAddress)aDestination);
        CRecordNetworkRoutePacket.setPacket((CRecord)rec, (Object)aPacket);
        this.sendNotification(env, rec);
    }

    private void sendStartReceiving() throws CException {
        CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)this.mConnection.getConnectionAddress());
        CRecord rec = CRecordConnectionStartReceiving.create();
        this.sendNotification(env, rec);
    }

    @Override
    public void sendToLocal(@NotNull CMessage aMsg) throws CException {
        CEnvelope env = aMsg.getEnvelope();
        if (CWellKnownTID.TRANSPORT.equals((Object)env.getReceiver().getTID())) {
            env.setReceiver(this.getAddress());
        }
        CEnvelope env2 = CEnvelope.forLocalNanoService(CRecordNetworkIncomingMessage.class);
        env2.setLogEnabled(false);
        CRecord rec2 = CRecordNetworkIncomingMessage.create();
        CRecordNetworkIncomingMessage.setConnectionId((CRecord)rec2, (UUID)this.mConnection.getID());
        CRecordNetworkIncomingMessage.setMessage((CRecord)rec2, (CMessage)aMsg);
        this.sendNotification(env2, rec2);
    }

    @Override
    public void sendToBridgeHead(@NotNull CNodeAddress aRemoteNode, @NotNull CMessage aMsg) throws CException {
        this.mBridgeHead.forwardMessage(aRemoteNode, aMsg);
    }

    private void startTimerForwardStats() {
        this.mDependencies.getTimerManager().createAndStartTimer(CRecordTimerForForwardStats.ID, this.getAddress(), 30000L, false, null);
    }

    @Override
    public void setConnection(@NotNull CConnectionDto aConnection) throws CException {
        this.mConnectionClosed = false;
        this.mConnection = aConnection;
        this.sendStartReceiving();
    }

    private void sendConnectionClosed(@NotNull UUID aID) throws CException {
        this.mConnectionClosed = true;
        LOG.debug("Transport: Connection closed: {}", new Object[]{this.mConnection.getRemoteNodeAddress()});
        CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)this.mOwner);
        CRecord record = CRecordNotifyConnectionClosed.create();
        CRecordNotifyConnectionClosed.setConnectionId(record, aID);
        this.sendNotification(env, record);
    }

    private void sendAddLinkToLinkCollector(@NotNull CNodeAddress aNodeAddress) throws CException {
        CEnvelope env = CEnvelope.forMicroService((IId)de.sillysky.nyssr.link.collector.CConstants.MICRO_SERVICE_ID);
        CRecord record = CRecordLinkCollectorAddLink.create();
        CRecordLinkCollectorAddLink.setNode1((CRecord)record, (CNodeAddress)CNodeAddress.getLocal());
        CRecordLinkCollectorAddLink.setNode2((CRecord)record, (CNodeAddress)aNodeAddress);
        this.sendNotification(env, record);
    }
}

