/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.packet.factory.jsonmessage;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.network.packet.factory.jsonmessage.CJsonHolder;
import de.sillysky.nyssr.impl.network.packet.factory.jsonmessage.IDependencies;
import de.sillysky.nyssr.impl.network.util.CUtilAes;
import de.sillysky.nyssr.impl.util.CJsonEnvelopeUtil;
import de.sillysky.nyssr.impl.util.CJsonRecordUtil;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.message.CMessage;
import de.sillysky.nyssr.message.EPriority;
import de.sillysky.nyssr.network.nodeinfo.CNodeInfoDto;
import de.sillysky.nyssr.network.packets.CPacketConstants;
import de.sillysky.nyssr.network.packets.EPacketType;
import de.sillysky.nyssr.network.packets.IPacketMessage;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.slot.ISlotFactory;
import de.sillysky.nyssr.util.zip.CUtilZip;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.SecretKey;
import org.jetbrains.annotations.NotNull;

public class CPacketJsonMessage
implements IPacketMessage {
    private static final ILogger LOG = CLoggerFactory.getLogger(CPacketJsonMessage.class);
    private static final ILogger PACKET_LOG = CLoggerFactory.getLogger((String)"network.packet");
    private static final ILogger JSON_MSG_BYTES_LOG = CLoggerFactory.getLogger((String)"network.message.bytes");
    private final IDependencies mDependencies;
    private final CJsonHolder mEnvelopeAddresses;
    private final CJsonHolder mEnvelopeOther;
    private final CJsonHolder mEnvelopeDebug;
    private final CJsonHolder mRecord;
    private final Map<Integer, byte[]> mByteArrayStore = new HashMap<Integer, byte[]>();
    private CMessage mMessage;
    private int mSequenceNumber;
    private byte[] mBytes;
    private byte[] mPayload2;

    CPacketJsonMessage(@NotNull IDependencies aDependencies, @NotNull CMessage aMessage, int aSequenceNumber) {
        this.mDependencies = aDependencies;
        this.mMessage = aMessage;
        this.mSequenceNumber = aSequenceNumber;
        CEnvelope envelope = aMessage.getEnvelope();
        CRecord record = aMessage.getRecord();
        CJsonObject jo = CJsonEnvelopeUtil.addressesToJson((CEnvelope)envelope);
        this.mEnvelopeAddresses = new CJsonHolder(this.mDependencies, "Addresses");
        this.mEnvelopeAddresses.setJsonObject(jo);
        jo = CJsonEnvelopeUtil.debugToJson((CEnvelope)envelope);
        this.mEnvelopeDebug = new CJsonHolder(this.mDependencies, "Debug");
        this.mEnvelopeDebug.setJsonObject(jo);
        jo = CJsonEnvelopeUtil.otherToJson((CEnvelope)envelope);
        this.mEnvelopeOther = new CJsonHolder(this.mDependencies, "Other");
        this.mEnvelopeOther.setJsonObject(jo);
        jo = CJsonRecordUtil.toJson((CRecord)record, this.mByteArrayStore);
        this.mRecord = new CJsonHolder(this.mDependencies, "Record");
        this.mRecord.setJsonObject(jo);
    }

    CPacketJsonMessage(@NotNull IDependencies aDependencies, byte @NotNull [] aBytes) {
        this.mDependencies = aDependencies;
        this.mBytes = aBytes;
        this.mEnvelopeAddresses = new CJsonHolder(this.mDependencies, "Addresses");
        this.mEnvelopeDebug = new CJsonHolder(this.mDependencies, "Debug");
        this.mEnvelopeOther = new CJsonHolder(this.mDependencies, "Other");
        this.mRecord = new CJsonHolder(this.mDependencies, "Record");
        try (ByteArrayInputStream byteIn = new ByteArrayInputStream(aBytes);
             DataInputStream dataIn = new DataInputStream(byteIn);){
            int sizeOfPayload1 = dataIn.readInt();
            byte[] payload1 = new byte[sizeOfPayload1];
            dataIn.readFully(payload1);
            int sizeOfPayload2 = dataIn.readInt();
            this.mPayload2 = new byte[sizeOfPayload2];
            dataIn.readFully(this.mPayload2);
            this.mEnvelopeAddresses.setBytes(payload1);
            this.mEnvelopeAddresses.unpack();
            CEnvelope env = new CEnvelope();
            this.mMessage = new CMessage(env, new CRecord(IId.INVALID));
            CJsonEnvelopeUtil.fromJsonAddresses((CJsonObject)this.mEnvelopeAddresses.getRoot(), (CEnvelope)env);
        }
        catch (CException | IOException aE) {
            LOG.error(aE, "Error reading Json Message from Input Stream.");
        }
    }

    private void unpackPayload2(byte @NotNull [] aBytes, String aPacketBuilderSequence, @NotNull CTargetAddress aSender) throws CException {
        PACKET_LOG.trace("JSON in: {} bytes total", new Object[]{aBytes.length});
        String pbs = "null";
        byte[] bytesPayload2 = aBytes;
        int sizeZip = 0;
        int sizeAes = 0;
        if (aPacketBuilderSequence != null) {
            pbs = aPacketBuilderSequence.toUpperCase();
            if (pbs.contains("A")) {
                sizeAes = bytesPayload2.length;
                CNodeInfoDto nodeRecord = this.mDependencies.getNodeInfoDatabase().getNodeInfo(aSender.getNodeAddress());
                if (nodeRecord == null) {
                    throw new CException(2101).append("Local NodeRecord not found, impossible to decrypt message");
                }
                SecretKey key = nodeRecord.getMySessionKey();
                if (key == null) {
                    throw new CException(2101).append("My SecretKey not found, impossible to decrypt message");
                }
                bytesPayload2 = CUtilAes.unpack(bytesPayload2, key, this);
            }
            if (pbs.contains("Z")) {
                sizeZip = bytesPayload2.length;
                bytesPayload2 = CUtilZip.unpackZip((byte[])bytesPayload2, (ILogger)LOG);
            }
        }
        int sizeMsg = bytesPayload2.length;
        try (ByteArrayInputStream byteIn = new ByteArrayInputStream(bytesPayload2);
             DataInputStream dataIn = new DataInputStream(byteIn);){
            int sizeDebug = dataIn.readInt();
            byte[] bytes = new byte[sizeDebug];
            dataIn.readFully(bytes);
            this.mEnvelopeDebug.setBytes(bytes);
            int sizeOther = dataIn.readInt();
            bytes = new byte[sizeOther];
            dataIn.readFully(bytes);
            this.mEnvelopeOther.setBytes(bytes);
            int sizeRecord = dataIn.readInt();
            bytes = new byte[sizeRecord];
            dataIn.readFully(bytes);
            this.mRecord.setBytes(bytes);
            this.mByteArrayStore.clear();
            int sizeByteArrayStore = 4;
            int byteArrayStoreSize = dataIn.readInt();
            for (int i = 0; i < byteArrayStoreSize; ++i) {
                int key = dataIn.readInt();
                int size = dataIn.readInt();
                byte[] value = new byte[size];
                dataIn.readFully(value);
                this.mByteArrayStore.put(key, value);
                sizeByteArrayStore += 8 + size;
            }
            JSON_MSG_BYTES_LOG.trace("JSON in PayLoad2: packetBuilderSequence={}, in={}, bytesAes={}, bytesZip={}, bytesMsg={}, ByteArrayStore={}-{}, jsonDebug={}, jsonOther={}, jsonRecord={}", new Object[]{pbs, aBytes.length, sizeAes, sizeZip, sizeMsg, this.mByteArrayStore.size(), sizeByteArrayStore, sizeDebug, sizeOther, sizeRecord});
        }
        catch (IOException aE) {
            LOG.error((Throwable)aE, "Error reading Json Message from Input Stream.");
        }
    }

    @Override
    public byte[] getPayload() {
        return this.mBytes;
    }

    @Override
    public EPacketType getType() {
        return EPacketType.JSON_MESSAGE;
    }

    @Override
    public void addHop(@NotNull CNodeAddress aNode) {
    }

    @Override
    public String getBuilderSequence() {
        return this.mMessage == null ? null : this.mMessage.getEnvelope().getPacketBuilderSequence();
    }

    @Override
    public CNodeAddress getDestination() {
        return this.mMessage == null ? null : this.mMessage.getEnvelope().getReceiver().getNodeAddress();
    }

    @Override
    public CMessage getMessage() {
        if (this.mMessage == null && this.mBytes != null) {
            try {
                this.unpack();
            }
            catch (CException aE) {
                LOG.error("Exception on unpacking JSON message", new Object[]{aE});
                return null;
            }
        }
        return this.mMessage;
    }

    @Override
    public EPriority getPriority() {
        return this.mMessage == null ? null : this.mMessage.getEnvelope().getPriority();
    }

    @Override
    public CNodeAddress getSource() {
        return this.mMessage == null ? null : this.mMessage.getEnvelope().getSender().getNodeAddress();
    }

    private byte[] packPayload1() throws CException {
        this.mEnvelopeAddresses.setBytes(null);
        this.mEnvelopeAddresses.getRoot().put("sequenceNumber", (Object)this.mSequenceNumber);
        this.mEnvelopeAddresses.pack();
        byte[] bytes = this.mEnvelopeAddresses.getPackedJson();
        PACKET_LOG.trace("JSON out Addresses: {}", new Object[]{bytes.length});
        return bytes;
    }

    private void packPayload2() throws CException {
        if (this.mPayload2 == null) {
            int sizeZip = 0;
            int sizeAes = 0;
            this.mEnvelopeDebug.pack();
            byte[] debug = this.mEnvelopeDebug.getPackedJson();
            this.mEnvelopeOther.pack();
            byte[] other = this.mEnvelopeOther.getPackedJson();
            this.mRecord.pack();
            byte[] record = this.mRecord.getPackedJson();
            int sizeByteArrayStore = 4;
            for (byte[] value : this.mByteArrayStore.values()) {
                sizeByteArrayStore += 8 + value.length;
            }
            try (ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
                 DataOutputStream dataOut = new DataOutputStream(byteOut);){
                dataOut.writeInt(debug.length);
                dataOut.write(debug);
                dataOut.writeInt(other.length);
                dataOut.write(other);
                dataOut.writeInt(record.length);
                dataOut.write(record);
                dataOut.writeInt(this.mByteArrayStore.size());
                for (Map.Entry<Integer, byte[]> entry : this.mByteArrayStore.entrySet()) {
                    Integer key = entry.getKey();
                    byte[] value = entry.getValue();
                    dataOut.writeInt(key);
                    dataOut.writeInt(value.length);
                    dataOut.write(value);
                }
                this.mPayload2 = byteOut.toByteArray();
                String packetBuilderSequence = this.mDependencies.getNodeInfoDatabase().getPacketBuilderSequence(this.mMessage);
                String pbs = packetBuilderSequence.toUpperCase();
                if (pbs.contains("Z")) {
                    sizeZip = this.mPayload2.length;
                    byte[] result = CUtilZip.pack((byte[])this.mPayload2, (ILogger)LOG);
                    if (result != null) {
                        this.mPayload2 = result;
                    } else {
                        pbs = pbs.replace("Z", "");
                    }
                }
                if (pbs.contains("A")) {
                    SecretKey key;
                    sizeAes = this.mPayload2.length;
                    CNodeInfoDto nodeRecord = this.mDependencies.getNodeInfoDatabase().getNodeInfo(this.mMessage.getEnvelope().getReceiver().getNodeAddress());
                    if (nodeRecord != null && (key = nodeRecord.getHisSessionKey()) != null) {
                        byte[] result = CUtilAes.pack(this.mPayload2, key, this);
                        if (result != null) {
                            this.mPayload2 = result;
                        } else {
                            pbs = pbs.replace("A", "");
                        }
                    }
                }
                int sizeMsg = this.mPayload2.length;
                String pbsEnv = this.mMessage.getEnvelope().getPacketBuilderSequence();
                if (!"M".equals(pbs) && !pbs.equals(pbsEnv)) {
                    this.mMessage.getEnvelope().setPacketBuilderSequence(pbs);
                    this.mEnvelopeAddresses.getRoot().put("packetBuilderSequence", (Object)pbs);
                }
                JSON_MSG_BYTES_LOG.trace("JSON out PayLoad2: packetBuilderSequence={}, bytesZip={}, bytesAes={}, bytesMsg={}, ByteArrayStore={}-{}, jsonDebug={}, jsonOther={}, jsonRecord={}, out={}", new Object[]{pbs, sizeZip, sizeAes, sizeMsg, this.mByteArrayStore.size(), sizeByteArrayStore, debug.length, other.length, record.length, this.mPayload2.length});
            }
            catch (IOException aE) {
                LOG.error("Exception on packing payload", new Object[]{aE});
            }
        }
    }

    @Override
    public void pack() throws CException {
        if (this.mMessage != null && this.mBytes == null) {
            this.packPayload2();
        }
        byte[] payload1 = this.packPayload1();
        try (ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
             DataOutputStream dataOut = new DataOutputStream(byteOut);){
            dataOut.write(CPacketConstants.PACKET_HEADER);
            dataOut.write(EPacketType.JSON_MESSAGE.getValue());
            dataOut.writeInt(4 + payload1.length + 4 + this.mPayload2.length);
            dataOut.writeInt(payload1.length);
            dataOut.write(payload1);
            dataOut.writeInt(this.mPayload2.length);
            dataOut.write(this.mPayload2);
            this.mBytes = byteOut.toByteArray();
            PACKET_LOG.trace("JSON out: {} bytes total", new Object[]{this.mBytes.length});
        }
        catch (IOException aE) {
            LOG.error("Exception on packing", new Object[]{aE});
        }
    }

    @Override
    public void unpack() throws CException {
        ISlotFactory sf = this.mDependencies.getSlotFactory();
        CEnvelope env = this.mMessage.getEnvelope();
        this.unpackPayload2(this.mPayload2, env.getPacketBuilderSequence(), env.getSender());
        this.mEnvelopeDebug.unpack();
        this.mEnvelopeOther.unpack();
        this.mRecord.unpack();
        CJsonEnvelopeUtil.fromJsonDebug((CJsonObject)this.mEnvelopeDebug.getRoot(), (CEnvelope)env);
        CJsonEnvelopeUtil.fromJsonOther((CJsonObject)this.mEnvelopeOther.getRoot(), (CEnvelope)env);
        CRecord record = CJsonRecordUtil.fromJson((Object)this.mRecord.getRoot(), this.mByteArrayStore, (ISlotFactory)sf);
        if (record == null) {
            throw new CException(2101).append("No record");
        }
        this.mMessage = new CMessage(env, record);
    }

    @Override
    public int size() {
        return this.mBytes == null ? 0 : this.mBytes.length;
    }
}

