/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.packet.builder.registry;

import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.network.packets.IPacketBuilder;
import de.sillysky.nyssr.network.packets.IPacketBuilderRegistry;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

final class CPacketBuilderRegistry
implements IPacketBuilderRegistry,
IService {
    private static final ILogger LOG = CLoggerFactory.getLogger(CPacketBuilderRegistry.class);
    private final Map<Character, IPacketBuilder> mBuilders = new HashMap<Character, IPacketBuilder>();

    CPacketBuilderRegistry() {
    }

    public static void getDependencies(IServiceDependencyList aDependencyList) {
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) {
        LOG.debug("Activate {}", new Object[]{this.getClass().getSimpleName()});
        aServiceRegistry.registerService(IPacketBuilderRegistry.class, (Object)this);
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        LOG.debug("Deactivate {}", new Object[]{this.getClass().getSimpleName()});
        aServiceRegistry.deregisterService((Object)this);
    }

    @Override
    public void deregisterPacketBuilder(@NotNull IPacketBuilder aBuilder) {
        char type = aBuilder.getType();
        this.mBuilders.remove(Character.valueOf(type));
    }

    @Override
    public IPacketBuilder get(char aType) {
        IPacketBuilder builder = this.mBuilders.get(Character.valueOf(aType));
        if (builder == null) {
            LOG.error("Unknown Packet Builder {}", (int)aType);
        }
        return builder;
    }

    @Override
    public void registerPacketBuilder(@NotNull IPacketBuilder aBuilder) {
        char type = aBuilder.getType();
        this.mBuilders.put(Character.valueOf(type), aBuilder);
    }
}

