/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.web.dialog.yesno;

import de.sillysky.nyssr.address.CNodeId;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.impl.web.dialog.yesno.C00001YesNo;
import de.sillysky.nyssr.impl.web.dialog.yesno.CConstants;
import de.sillysky.nyssr.impl.web.dialog.yesno.IDependencies;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.nanoservice.CDescriptionOfRecord;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.remoteskin.web.dialog.records.CRecordShowWebDialog;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.util.properties.CStringProperties;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

class C00001YesNoFactory
extends CTarget
implements IService {
    private final IDependencies mDependencies;

    public C00001YesNoFactory(@NotNull IDependencies aDependencies) {
        this.mDependencies = aDependencies;
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordShowWebDialog.ID, this::asyncShowWebDialog);
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        IId nid = CIdFactory.fromObject((Object)"WebDialogYesNo_00001");
        INamespace ns = this.mDependencies.getNamespaceFactory().createAndRegisterNamespace(nid, "WebDialogYesNo_00001");
        ns.getTargetRegistry().registerTarget((ITarget)this);
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        this.mDependencies.getHelperForLocalMicroServices().deregisterMicroServices(this.getAddress());
        this.deregisterTarget();
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.registerMicroService();
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncShowWebDialog(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        byte[] sessionToken = aEnvelope.getSessionToken();
        CUtilCheck.checkNotNull((Object)sessionToken, (String)"sessionToken missing", (Object[])new Object[0]);
        CTargetAddress clientTargetAddress = CRecordShowWebDialog.getClientTargetAddress((CRecord)aRecord, null);
        CUtilCheck.checkNotNull((Object)clientTargetAddress, (String)"clientTargetAddress missing", (Object[])new Object[0]);
        CTargetAddress ownerTargetAddress = CRecordShowWebDialog.getOwnerTargetAddress((CRecord)aRecord, null);
        CUtilCheck.checkNotNull((Object)ownerTargetAddress, (String)"ownerTargetAddress missing", (Object[])new Object[0]);
        String parentWidgetId = CRecordShowWebDialog.getParentWidgetId((CRecord)aRecord, (String)"id_00001_modal");
        CUtilCheck.checkEmptyString((Object)parentWidgetId, (String)"ParentWidgetId missing", (Object[])new Object[0]);
        CStringProperties params = CRecordShowWebDialog.getParams((CRecord)aRecord, (CStringProperties)new CStringProperties());
        String message = params.get("message");
        CUtilCheck.checkNotNull((Object)message, (String)"Message missing", (Object[])new Object[0]);
        C00001YesNo tgt = new C00001YesNo(clientTargetAddress, ownerTargetAddress, parentWidgetId, params);
        this.getTargetRegistry().registerTarget((ITarget)tgt);
        CRecordShowWebDialog.setDialogTargetAddress((CRecord)aRecord, (CTargetAddress)tgt.getAddress());
        aEnvelope.setResultSuccess();
        return true;
    }

    private void registerMicroService() throws CException {
        ArrayList<CDescriptionOfRecord> nanos = new ArrayList<CDescriptionOfRecord>();
        nanos.add(new CDescriptionOfRecord(CRecordShowWebDialog.ID, "Create and show the edit role dialog"));
        this.mDependencies.getHelperForLocalMicroServices().registerMicroService(CConstants.MICRO_SERVICE_ID, "WebDialogYesNo_00001", nanos, CNodeId.getLocal().getId(), this.getAddress());
    }
}

