/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util.files;

import java.io.File;
import javax.swing.filechooser.FileFilter;

public class CExtensionFileChooserFilter
extends FileFilter {
    private final String[] mExtensions;
    private final String mDescription;

    public CExtensionFileChooserFilter(String aDescription, String aExtension) {
        this(aDescription, new String[]{aExtension});
    }

    public CExtensionFileChooserFilter(String aDescription, String[] aExtensions) {
        this.mDescription = aDescription;
        this.mExtensions = new String[aExtensions.length];
        for (int i = 0; i < aExtensions.length; ++i) {
            this.mExtensions[i] = aExtensions[i].toLowerCase();
        }
    }

    @Override
    public boolean accept(File aFile) {
        if (aFile.isDirectory()) {
            return true;
        }
        String filePath = aFile.getAbsolutePath().toLowerCase();
        for (String ext : this.mExtensions) {
            int index;
            char c;
            if (!filePath.endsWith(ext) || (c = filePath.charAt(index = filePath.length() - ext.length() - 1)) != '.') continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDescription() {
        return this.mDescription;
    }
}

