/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util;

import de.sillysky.nyssr.util.CPositiveInteger;
import de.sillysky.nyssr.util.CUtilRandom;
import de.sillysky.nyssr.util.array.CUtilArray;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CUtilBooleanArray {
    public static final boolean[] EMPTY = new boolean[0];

    private CUtilBooleanArray() {
    }

    public static boolean[] copy(boolean[] aValue) {
        if (aValue == null) {
            return null;
        }
        if (aValue.length == 0) {
            return EMPTY;
        }
        return Arrays.copyOf(aValue, aValue.length);
    }

    public static boolean[] fromList(@Nullable List<?> aValue) {
        if (aValue == null || aValue.isEmpty()) {
            return EMPTY;
        }
        ArrayList<Boolean> list = new ArrayList<Boolean>();
        for (Object element : aValue) {
            Object[] bb;
            if (element == null) continue;
            if (element instanceof Boolean) {
                list.add((Boolean)element);
                continue;
            }
            if (element instanceof boolean[]) {
                bb = (boolean[])element;
                for (Object b : (Object)bb) {
                    list.add((boolean)b);
                }
                continue;
            }
            if (element instanceof Boolean[]) {
                bb = (Boolean[])element;
                Collections.addAll(list, bb);
                continue;
            }
            if (!(element instanceof String)) continue;
            bb = CUtilBooleanArray.fromString((String)element);
            for (Object b : (Object)bb) {
                list.add((boolean)b);
            }
        }
        int count = list.size();
        boolean[] arr = new boolean[count];
        int pos = 0;
        for (Boolean element : list) {
            arr[pos] = element;
            ++pos;
        }
        return arr;
    }

    public static boolean @Nullable [] fromStream(@NotNull DataInput aStream) throws IOException {
        int len = CPositiveInteger.fromStream(aStream);
        if (len == 0) {
            return null;
        }
        boolean[] value = new boolean[len - 1];
        for (int i = 0; i < len - 1; ++i) {
            value[i] = aStream.readBoolean();
        }
        return value;
    }

    public static boolean[] fromString(@Nullable String aValue) {
        boolean[] arr;
        if (aValue == null || aValue.isEmpty()) {
            arr = EMPTY;
        } else {
            String[] tokens = aValue.split(",", -1);
            arr = new boolean[tokens.length];
            for (int i = 0; i < tokens.length; ++i) {
                arr[i] = Boolean.parseBoolean(tokens[i]);
            }
        }
        return arr;
    }

    public static boolean isEqual(boolean[] aValue1, boolean[] aValue2) {
        return Arrays.equals(aValue1, aValue2);
    }

    @NotNull
    public static String toString(boolean @Nullable [] aValue, char aDelimiter, int aMaxLen) {
        if (aValue == null) {
            return "null";
        }
        return CUtilArray.toString(0, aDelimiter, aMaxLen, index -> index >= aValue.length ? "\uf00bE" : Boolean.toString(aValue[index]));
    }

    public static void toStream(@NotNull DataOutput aStream, boolean @Nullable [] aValue) throws IOException {
        if (aValue == null) {
            CPositiveInteger.toStream(aStream, 0);
        } else {
            CPositiveInteger.toStream(aStream, aValue.length + 1);
            for (boolean element : aValue) {
                aStream.writeBoolean(element);
            }
        }
    }

    public static boolean @NotNull [] random(int aSize) {
        boolean[] array = new boolean[aSize];
        for (int i = 0; i < aSize; ++i) {
            array[i] = CUtilRandom.getRandom().nextBoolean();
        }
        return array;
    }
}

