/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.message.queue.records;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.ISlot;
import org.jetbrains.annotations.NotNull;

public final class CRecordCreateAsyncQueue
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject("6ffb4518-7b07-4666-8771-23f1119e1e72");
    public static final String NAME = "CreateAsyncQueue";
    public static final String DESCRIPTION = "Create and register an asynchronous message queue for a given namespace. Receiver: namespace";
    public static final String SLOT_DESCRIPTION = "1";
    public static final String SLOT_QID = "3";
    public static final String SLOT_THREAD_PRIORITY = "2";
    public static final String[] NAMESPACES = new String[]{"*"};
    public static final boolean IS_NANO_SERVICE = true;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static String getDescription(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_DESCRIPTION);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static IId getQid(@NotNull CRecord aRecord, IId aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_QID);
        if (slot == null) {
            return aDefault;
        }
        return (IId)slot.getValue();
    }

    public static int getThreadPriority(@NotNull CRecord aRecord, int aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_THREAD_PRIORITY);
        if (slot == null) {
            return aDefault;
        }
        return (Integer)slot.getValue();
    }

    public static void setDescription(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.STRING, aValue);
        aRecord.addSlot(SLOT_DESCRIPTION, slot);
    }

    public static void setQid(@NotNull CRecord aRecord, IId aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.ID, aValue);
        aRecord.addSlot(SLOT_QID, slot);
    }

    public static void setThreadPriority(@NotNull CRecord aRecord, int aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.INT, aValue);
        aRecord.addSlot(SLOT_THREAD_PRIORITY, slot);
    }
}

