/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.log.catcher.records;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.ISlot;
import org.jetbrains.annotations.NotNull;

public final class CRecordServiceSetLogPattern
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject("d8995a2b-1695-4edc-a9d4-89610d41bebd");
    public static final String NAME = "ServiceSetLogPattern";
    public static final String DESCRIPTION = "Set the pattern for the log catcher.";
    public static final String SLOT_PATTERN = "1";
    public static final String[] NAMESPACES = new String[]{"SYSTEM"};
    public static final boolean IS_NANO_SERVICE = true;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static String getPattern(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_PATTERN);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static void setPattern(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.STRING, aValue);
        aRecord.addSlot(SLOT_PATTERN, slot);
    }
}

