/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.json;

import de.sillysky.nyssr.json.CJsonBase;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.util.CUtilString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CJsonArray
extends CJsonBase {
    private final List<Object> mValues = new ArrayList<Object>();

    public CJsonArray() {
    }

    public CJsonArray(@Nullable Collection<String> aStrings) {
        if (aStrings != null) {
            for (String s : aStrings) {
                if (!CUtilString.isValid(s)) continue;
                this.add(s);
            }
        }
    }

    public CJsonArray(@Nullable String[] aStrings) {
        if (aStrings != null) {
            for (String s : aStrings) {
                if (!CUtilString.isValid(s)) continue;
                this.add(s);
            }
        }
    }

    public void add(@NotNull Object aValue) {
        this.mValues.add(aValue);
    }

    public boolean equals(Object aO) {
        if (this == aO) {
            return true;
        }
        if (aO == null || this.getClass() != aO.getClass()) {
            return false;
        }
        CJsonArray that = (CJsonArray)aO;
        return this.mValues.equals(that.mValues);
    }

    public int hashCode() {
        return Objects.hash(this.mValues);
    }

    public boolean contains(@NotNull Object aValue) {
        return this.mValues.contains(aValue);
    }

    @NotNull
    public List<Object> getChildren() {
        return new ArrayList<Object>(this.mValues);
    }

    @NotNull
    public List<String> getStringList() {
        ArrayList<String> list = new ArrayList<String>();
        for (Object o : this.mValues) {
            if (!(o instanceof String)) continue;
            list.add((String)o);
        }
        return list;
    }

    @NotNull
    public Object getValue(int aIndex) {
        return this.mValues.get(aIndex);
    }

    public boolean remove(@NotNull Object aValue) {
        return this.mValues.remove(aValue);
    }

    public int size() {
        return this.mValues.size();
    }

    public void replace(@NotNull Object aValueToReplace, @NotNull Object aReplacement) {
        int index = this.mValues.indexOf(aValueToReplace);
        if (index >= 0) {
            this.mValues.set(index, aReplacement);
        }
    }

    @NotNull
    public CJsonArray getCopy() {
        CJsonArray arr = new CJsonArray();
        for (Object value : this.mValues) {
            if (value instanceof CJsonObject) {
                arr.add(((CJsonObject)value).getCopy());
                continue;
            }
            if (value instanceof CJsonArray) {
                arr.add(((CJsonArray)value).getCopy());
                continue;
            }
            arr.add(value);
        }
        return arr;
    }
}

