/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.configuration.files.records;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.ISlot;
import de.sillysky.nyssr.util.properties.CStringProperties;
import org.jetbrains.annotations.NotNull;

public final class CRecordGetPreferenceList
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject("05a738fe-2b6f-4060-8fc9-21caab3d0148");
    public static final String NAME = "GetPreferenceList";
    public static final String DESCRIPTION = "Get all local preferences for a given node.";
    public static final String SLOT_KEY_VALUE_PAIRS = "11";
    public static final String SLOT_NODES = "10";
    public static final String[] NAMESPACES = new String[]{"SYSTEM"};
    public static final boolean IS_NANO_SERVICE = true;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static CStringProperties getKeyValuePairs(@NotNull CRecord aRecord, CStringProperties aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_KEY_VALUE_PAIRS);
        if (slot == null) {
            return aDefault;
        }
        return (CStringProperties)slot.getValue();
    }

    public static String[] getNodes(@NotNull CRecord aRecord, String[] aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_NODES);
        if (slot == null) {
            return aDefault;
        }
        return (String[])slot.getValue();
    }

    public static void setKeyValuePairs(@NotNull CRecord aRecord, CStringProperties aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.STRING_PROPERTIES, aValue);
        aRecord.addSlot(SLOT_KEY_VALUE_PAIRS, slot);
    }

    public static void setNodes(@NotNull CRecord aRecord, String[] aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.STRING_ARRAY, aValue);
        aRecord.addSlot(SLOT_NODES, slot);
    }
}

