/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.target;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.common.CWellKnownNID;
import de.sillysky.nyssr.id.common.CWellKnownTID;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.namedb.INameDb;
import de.sillysky.nyssr.namespace.IRecordHelper;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.remoteskin.client.IRemoteSkinClientContextFactory;
import de.sillysky.nyssr.remoteskin.client.IRemoteSkinClientContextTargetFactory;
import de.sillysky.nyssr.remoteskin.server.connector.CClientContextDto;
import de.sillysky.nyssr.remoteskin.server.connector.IRemoteSkinClientContext;
import de.sillysky.nyssr.remoteskin.server.records.CRecordRemoteSkinStartContext;
import de.sillysky.nyssr.remoteskin.server.records.CRecordRemoteSkinStopContext;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.ITargetRegistry;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.util.CUtilString;
import org.jetbrains.annotations.NotNull;

final class CTargetRemoteSkinClient
extends CTarget
implements IService {
    private static final ILogger LOG = CLoggerFactory.getLogger(CTargetRemoteSkinClient.class);
    private static final String FILTER = "nid=" + String.valueOf(CWellKnownNID.SYSTEM);
    private IRemoteSkinClientContextFactory mContextFactory;
    private INameDb mNameDb;
    private IRecordHelper mRecordHelper;
    private IRemoteSkinClientContextTargetFactory mClientContextTargetFactory;

    CTargetRemoteSkinClient() {
    }

    static void addDependencies(@NotNull IServiceDependencyList aDependencyList) {
        aDependencyList.add(INameDb.class);
        aDependencyList.add(IRemoteSkinClientContextFactory.class);
        aDependencyList.add(IRemoteSkinClientContextTargetFactory.class);
        aDependencyList.add(ITargetRegistry.class, FILTER);
        aDependencyList.add(IRecordHelper.class);
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        LOG.debug("Activate {}", new Object[]{((Object)((Object)this)).getClass().getSimpleName()});
        this.mNameDb = (INameDb)aServiceRegistry.getService(INameDb.class);
        this.mRecordHelper = (IRecordHelper)aServiceRegistry.getService(IRecordHelper.class);
        this.mContextFactory = (IRemoteSkinClientContextFactory)aServiceRegistry.getService(IRemoteSkinClientContextFactory.class);
        this.mClientContextTargetFactory = (IRemoteSkinClientContextTargetFactory)aServiceRegistry.getService(IRemoteSkinClientContextTargetFactory.class);
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordRemoteSkinStartContext.ID, this::asyncStartContext);
        this.addMessageHandler(CRecordRemoteSkinStopContext.ID, this::asyncStopContext);
        ITargetRegistry targetRegistry = (ITargetRegistry)aServiceRegistry.getService(ITargetRegistry.class, FILTER);
        assert (targetRegistry != null);
        targetRegistry.registerTarget((ITarget)this, CWellKnownTID.REMOTE_SKIN_CLIENT);
    }

    private boolean asyncStartContext(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws Exception {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        IId contextId = CRecordRemoteSkinStartContext.getContextId((CRecord)aRecord, null);
        CTargetAddress owner = CRecordRemoteSkinStartContext.getOwner((CRecord)aRecord, (CTargetAddress)aEnvelope.getSender());
        String platformType = CRecordRemoteSkinStartContext.getPlatform((CRecord)aRecord, null);
        if (CUtilString.isEmpty((String)platformType)) {
            aEnvelope.setResult(8, "Missing Platform");
            return true;
        }
        CClientContextDto dto = new CClientContextDto(contextId, owner, platformType);
        de.sillysky.nyssr.remoteskin.model.IRemoteSkinClientContext context = this.mContextFactory.startContext((IRemoteSkinClientContext)dto);
        if (context == null) {
            aEnvelope.setResult(8, "Unknown Platform");
            return true;
        }
        CTargetAddress address = this.mClientContextTargetFactory.createTarget(context);
        CRecordRemoteSkinStartContext.setContextAddress((CRecord)aRecord, (CTargetAddress)address);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CTargetAddress address = this.getAddress();
        this.mNameDb.getTargetAddressDatabase().putName(address, "RemoteSkinClient");
        this.mRecordHelper.addObserver(CRecordRemoteSkinStartContext.class, (ITarget)this, true);
        this.mRecordHelper.addObserver(CRecordRemoteSkinStopContext.class, (ITarget)this, true);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncStopContext(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        IId contextId = CRecordRemoteSkinStopContext.getContextId((CRecord)aRecord, null);
        CUtilCheck.checkNotNull((Object)contextId, (String)"Missing Context ID.", (Object[])new Object[0]);
        this.mContextFactory.stopContext(contextId);
        this.mClientContextTargetFactory.deleteTarget(contextId);
        aEnvelope.setResultSuccess();
        return true;
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        LOG.debug("Deactivate {}", new Object[]{((Object)((Object)this)).getClass().getSimpleName()});
        this.deregisterTarget();
    }
}

