/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.cli.display;

import de.sillysky.nyssr.address.CNodeId;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.cli.records.CRecordCliAttachDisplay;
import de.sillysky.nyssr.cli.records.CRecordCliGetHelp;
import de.sillysky.nyssr.cli.records.CRecordCliHandle;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.common.CWellKnownNID;
import de.sillysky.nyssr.impl.cli.display.IDependencies;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.login.records.CRecordSessionExpired;
import de.sillysky.nyssr.login.records.CRecordSessionLogin;
import de.sillysky.nyssr.login.records.CRecordSessionLogout;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.result.CResult;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.session.verifier.CSessionData;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.util.hash.CUtilPassword;
import de.sillysky.nyssr.util.string.CUtilBase64;
import java.io.Console;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Scanner;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

class CCliDisplayTarget
extends CTarget
implements IService {
    private static final ILogger LOG = CLoggerFactory.getLogger(CCliDisplayTarget.class);
    private static final String CONNECT = "connect";
    private static final String LOGIN = "login";
    private static final String LOGOUT = "logout";
    private static final String LOGOFF = "logoff";
    private final IDependencies mDependencies;
    private Thread mThread;
    private boolean mStop = false;
    private final AtomicBoolean mRunning = new AtomicBoolean(false);
    private final HashSet<String> mHistory = new HashSet();
    private final String mLock = "";
    private String mPrompt = ">";
    private CNodeId mNodeId = CNodeId.getLocal();
    private String mUserId = null;
    private byte[] mSessionToken = null;
    private CTargetAddress mManagerAddress = null;
    private static final IId MICRO_SERVICE_SESSION = CIdFactory.fromObject((Object)"ccf168c1-f18b-4229-85f9-24461a19ee6a");

    CCliDisplayTarget(@NotNull IDependencies aDependencies) {
        this.mDependencies = aDependencies;
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordCliAttachDisplay.ID, this::asyncAnswerAttachDisplay);
        this.addMessageHandler(CRecordCliGetHelp.ID, this::asyncAnswerGetHelp);
        this.addMessageHandler(CRecordCliHandle.ID, this::asyncAnswerHandle);
        this.addMessageHandler(CRecordSessionLogin.ID, this::asyncSessionLogin);
        this.addMessageHandler(CRecordSessionLogout.ID, this::asyncSessionLogout);
        this.addMessageHandler(CRecordSessionExpired.ID, this::asyncSessionExpired);
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        INamespace ns = this.mDependencies.getNamespaceRegistry().getNamespace(CWellKnownNID.SYSTEM);
        assert (ns != null);
        IId tid = CIdFactory.fromObject((Object)"CliDisplay");
        ns.getTargetRegistry().registerTarget((ITarget)this, tid);
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        this.deregisterTarget();
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.mDependencies.getRecordHelper().addObserver(CRecordSessionExpired.class, (ITarget)this, false);
        this.startInput();
        this.attachDisplay(CNodeId.getLocal());
        aEnvelope.setResultSuccess();
        return true;
    }

    private void startInput() {
        if (!this.mRunning.get()) {
            this.mThread = new Thread(this::input);
            this.mThread.start();
        }
    }

    private boolean asyncAnswerAttachDisplay(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            CResult result = aEnvelope.getResult();
            if (result.hasSuccess()) {
                this.mManagerAddress = aEnvelope.getSender();
            } else {
                CNodeId nodeId = aEnvelope.getSender().getNodeId();
                this.printError("Can't connect Node " + String.valueOf(nodeId) + ": " + result.getText());
            }
            this.printPrompt();
            return true;
        }
        return false;
    }

    private boolean asyncAnswerGetHelp(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            CResult result = aEnvelope.getResult();
            if (result.hasSuccess()) {
                String help = CRecordCliGetHelp.getHelp((CRecord)aRecord, (String)"?");
                this.println(help);
            } else {
                CNodeId nodeId = aEnvelope.getSender().getNodeId();
                this.printError("Can't get Help from " + String.valueOf(nodeId) + ": " + result.getText());
            }
            this.printPrompt();
            return true;
        }
        return false;
    }

    private boolean asyncAnswerHandle(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            CResult result = aEnvelope.getResult();
            if (result.hasSuccess()) {
                String output;
                String commandLine;
                boolean isValidCommand = CRecordCliHandle.getIsValidCommand((CRecord)aRecord, (boolean)false);
                if (isValidCommand && !(commandLine = CRecordCliHandle.getCommandLine((CRecord)aRecord, (String)"")).isEmpty()) {
                    this.mHistory.add(commandLine);
                }
                if (!(output = CRecordCliHandle.getOutput((CRecord)aRecord, (String)"")).isEmpty()) {
                    this.println(output);
                }
            } else {
                CNodeId nodeId = aEnvelope.getSender().getNodeId();
                this.printError("Can't handle that command for " + String.valueOf(nodeId) + ": " + result.getText());
            }
            this.printPrompt();
            return true;
        }
        return false;
    }

    private boolean asyncSessionLogin(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            CResult result = aEnvelope.getResult();
            LOG.info("Session LogIn: {}", new Object[]{result});
            int resultCode = result.getCode();
            if (resultCode == 0) {
                CSessionData sessionData = this.mDependencies.getSessionVerifier().verifySessionToken(aEnvelope.getSessionToken());
                this.mSessionToken = sessionData == null ? aEnvelope.getSessionToken() : sessionData.getShortToken();
                this.mUserId = CRecordSessionLogin.getUserId((CRecord)aRecord, null);
                System.out.println("Successfully logged in as " + this.mUserId);
                System.out.println("Your session token is " + CUtilBase64.encodeToString((byte[])this.mSessionToken));
            } else {
                this.printError("Error on login: " + result.getText());
                this.mSessionToken = null;
                this.mUserId = null;
            }
            this.printPrompt();
            return true;
        }
        return false;
    }

    private boolean asyncSessionLogout(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            this.mSessionToken = null;
            this.mUserId = null;
            this.println("You are logged out.");
            this.printPrompt();
            return true;
        }
        return false;
    }

    private boolean asyncSessionExpired(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        byte[] sessionToken = aEnvelope.getSessionToken();
        if (sessionToken != null && Arrays.equals(sessionToken, this.mSessionToken)) {
            this.mSessionToken = null;
            this.mUserId = null;
            this.println("Session expired.");
            this.printPrompt();
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private void attachDisplay(@NotNull CNodeId aNodeId) throws CException {
        this.mManagerAddress = null;
        this.mNodeId = aNodeId;
        CEnvelope env = CEnvelope.forRemoteNanoService((IId)CWellKnownNID.SYSTEM, (CNodeId)aNodeId);
        CRecord record = CRecordCliAttachDisplay.create();
        this.sendRequest(env, record);
    }

    private void getHelp() throws CException {
        if (this.mManagerAddress != null) {
            CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)this.mManagerAddress);
            CRecord record = CRecordCliGetHelp.create();
            this.sendRequest(env, record);
        } else {
            LOG.error("No CLI Manager found.");
        }
    }

    private void sendCommandLine(String aLine) throws CException {
        if (this.mManagerAddress != null) {
            CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)this.mManagerAddress);
            env.setSessionToken(this.mSessionToken);
            CRecord record = CRecordCliHandle.create();
            CRecordCliHandle.setCommandLine((CRecord)record, (String)aLine.trim());
            CRecordCliHandle.setDisplay((CRecord)record, (CTargetAddress)this.getAddress());
            this.sendRequest(env, record);
        } else {
            LOG.error("No CLI Manager found.");
        }
    }

    public void notifyTargetDeRegistered() {
        if (this.mThread != null) {
            this.mStop = true;
            this.mThread.interrupt();
            this.mThread = null;
        }
        super.notifyTargetDeRegistered();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printPrompt() {
        this.mPrompt = this.mUserId != null ? "\u001b[92m" + this.mUserId + "@" + String.valueOf(this.mNodeId) + ":> \u001b[0m" : "\u001b[92m" + String.valueOf(this.mNodeId) + ":> \u001b[0m";
        String string = "";
        synchronized ("") {
            "".notify();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void printList(@NotNull Set<String> aList) {
        if (!aList.isEmpty()) {
            TreeSet<String> tree = new TreeSet<String>(aList);
            int max = Math.min(200, tree.size());
            int i = 0;
            for (String s : tree) {
                String no = String.format("#%03d", i);
                System.out.println(no + " " + s);
                if (++i <= max) continue;
                break;
            }
        } else {
            this.println("History list is empty");
        }
    }

    private void println(@NotNull String aText) {
        System.out.print("\u001b[94m");
        System.out.print(aText);
        System.out.println("\u001b[0m");
    }

    private void printError(@NotNull String aText) {
        System.out.print("\u001b[41m");
        System.out.print(aText);
        System.out.println("\u001b[0m");
    }

    private void handleLine(@NotNull String aLine) throws CException {
        String line = aLine.toLowerCase().trim();
        if ("help".equals(line) || "?".equals(aLine)) {
            this.getHelp();
        } else if (LOGIN.equals(line)) {
            this.login();
        } else if (LOGOUT.equals(line)) {
            this.logout();
        } else if (LOGOFF.equals(line)) {
            this.logout();
        } else if (line.startsWith("connect ")) {
            int pos = line.indexOf(32);
            if (pos > 0) {
                String nodeString = line.substring(CONNECT.length()).trim();
                CNodeId nodeId = new CNodeId(nodeString);
                this.attachDisplay(nodeId);
            } else {
                this.println("Connects needs a node id.");
                this.printPrompt();
            }
        } else {
            this.sendCommandLine(aLine);
        }
    }

    private void input() {
        this.mRunning.set(true);
        this.mStop = false;
        Scanner scanner = null;
        Console console = System.console();
        if (console == null) {
            scanner = new Scanner(System.in);
        }
        while (true) {
            try {
                do {
                    String line;
                    if (console != null) {
                        line = console.readLine(this.mPrompt, new Object[0]);
                    } else {
                        System.out.print(this.mPrompt);
                        line = scanner.nextLine();
                    }
                    if (line == null || (line = line.trim()).isEmpty()) continue;
                    this.handleLine(line);
                    this.waitForPrompt();
                } while (!this.mStop);
                LOG.debug("CLI Thread stopped.");
                return;
            }
            catch (CException aE) {
                LOG.error((Throwable)aE);
                continue;
            }
            catch (Exception aE) {
                LOG.error((Throwable)aE);
                System.out.println("Use 'quit' to stop the node");
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForPrompt() {
        String string = "";
        synchronized ("") {
            try {
                "".wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return;
        }
    }

    private void login() throws CException {
        String pwHash;
        String username;
        Console console = System.console();
        if (console == null) {
            System.out.println("No Console available (IDE?). The credentials are entered using a scanner:");
            Scanner scanner = new Scanner(System.in);
            System.out.println("Please enter your username: ");
            username = scanner.nextLine();
            System.out.println("Please enter your password: ");
            String password = scanner.nextLine();
            pwHash = CUtilPassword.hashPassword((char[])password.toCharArray());
        } else {
            username = console.readLine("Please enter your username: ", new Object[0]);
            char[] passwordArray = console.readPassword("Please enter your password: ", new Object[0]);
            pwHash = CUtilPassword.hashPassword((char[])passwordArray);
            Arrays.fill(passwordArray, ' ');
            console.flush();
        }
        this.login(username, pwHash == null ? "" : pwHash);
    }

    private void logout() throws CException {
        if (this.mSessionToken == null) {
            this.println("You are not logged in.");
            this.printPrompt();
        } else {
            CEnvelope env = CEnvelope.forMicroService((IId)MICRO_SERVICE_SESSION);
            env.setSessionToken(this.mSessionToken);
            CRecord record = CRecordSessionLogout.create();
            this.sendRequest(env, record);
        }
    }

    private void login(@NotNull String aUserName, @NotNull String aPassword) throws CException {
        CEnvelope env = CEnvelope.forMicroService((IId)MICRO_SERVICE_SESSION);
        CRecord record = CRecordSessionLogin.create();
        CRecordSessionLogin.setUserId((CRecord)record, (String)aUserName.trim());
        CRecordSessionLogin.setPassword((CRecord)record, (String)aPassword.trim());
        this.sendRequest(env, record);
    }
}

