/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util.files;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.files.CUtilPath;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CUtilFile {
    private static final ILogger LOG = CLoggerFactory.getLogger(CUtilFile.class);
    private static final String SRC = "src";
    private static final char COLON = ':';
    private static final CopyOption[] OVERWRITE1 = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES, LinkOption.NOFOLLOW_LINKS};
    private static final CopyOption[] NO_OVERWRITE1 = new CopyOption[]{StandardCopyOption.COPY_ATTRIBUTES, LinkOption.NOFOLLOW_LINKS};
    private static final CopyOption[] OVERWRITE2 = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
    private static final CopyOption[] NO_OVERWRITE2 = new CopyOption[0];

    private CUtilFile() {
    }

    public static void createEmptyFile(@NotNull File aFile, long aLength, boolean aOverWriteExistingFile) throws CException {
        if (aFile.exists()) {
            long length = aFile.length();
            if (aLength == length) {
                return;
            }
            if (!aOverWriteExistingFile) {
                throw new CException(2208);
            }
        }
        aFile.getParentFile().mkdirs();
        try (RandomAccessFile f = new RandomAccessFile(aFile, "rw");){
            f.setLength(aLength);
        }
        catch (Exception aE) {
            throw new CException(aE);
        }
    }

    @Nullable
    public static File findFileRecursive(@NotNull File aDirectory, @NotNull String aFilename) {
        File[] list = aDirectory.listFiles();
        if (list != null) {
            for (File f : list) {
                if (f.isDirectory()) {
                    File ff = CUtilFile.findFileRecursive(f, aFilename);
                    if (ff == null) continue;
                    return ff;
                }
                if (!aFilename.equalsIgnoreCase(f.getName())) continue;
                return f;
            }
        }
        return null;
    }

    public static String getPackage(String aDirectory, String aSourcePrefix) {
        String prefix1 = CUtilString.nonEmpty(aSourcePrefix, SRC);
        String prefix2 = CUtilPath.normalizeSlashesInPath(prefix1);
        int prefix1Length = prefix1.length();
        int prefix2Length = prefix2.length();
        int pos1 = aDirectory.indexOf(prefix1);
        int pos2 = aDirectory.indexOf(prefix2);
        String temp = pos1 >= 0 ? aDirectory.substring(pos1 + prefix1Length).toLowerCase() : (pos2 >= 0 ? aDirectory.substring(pos2 + prefix2Length).toLowerCase() : aDirectory);
        StringBuilder sb = new StringBuilder(prefix1Length);
        for (int i = 0; i < temp.length(); ++i) {
            char c = temp.charAt(i);
            if (c == '/' || c == '\\') {
                if (sb.length() == 0) continue;
                sb.append('.');
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] readChunk(File aFile, long aPosition, int aSize) throws CException {
        LOG.debug("Read chunk of file {}, index={}, pos={}, size={}", aFile, aPosition / (long)aSize, aPosition, aSize);
        try (FileChannel fc = FileChannel.open(aFile.toPath(), StandardOpenOption.READ);){
            fc.position(aPosition);
            ByteBuffer buf = ByteBuffer.allocate(aSize);
            int read = fc.read(buf);
            if (read >= 0) {
                byte[] data = new byte[read];
                System.arraycopy(buf.array(), 0, data, 0, read);
                byte[] byArray2 = data;
                return byArray2;
            }
            byte[] byArray = null;
            return byArray;
        }
        catch (IOException e) {
            throw new CException(e).append("Error reading chunk from ").append(aFile.toString());
        }
    }

    public static String readTextFile(String aPath, Charset aEncoding) throws IOException {
        byte[] bytes = Files.readAllBytes(Paths.get(aPath, new String[0]));
        return new String(bytes, aEncoding);
    }

    @NotNull
    public static String readTextFile(@NotNull Path aPath, @NotNull Charset aEncoding) throws IOException {
        byte[] bytes = Files.readAllBytes(aPath);
        return new String(bytes, aEncoding);
    }

    public static void writeChunk(@NotNull File aFile, long aFilePosition, byte[] aData, int aDataStartPos, int aDataLength) throws CException {
        try (FileChannel fc = FileChannel.open(aFile.toPath(), StandardOpenOption.WRITE, StandardOpenOption.READ);){
            fc.position(aFilePosition);
            ByteBuffer buf = ByteBuffer.allocate(aDataLength);
            buf.put(aData, aDataStartPos, aDataLength);
            buf.rewind();
            fc.write(buf);
            fc.force(true);
        }
        catch (IOException aE) {
            throw new CException(aE);
        }
    }

    public static boolean createDirectories(Path aPath) {
        if (aPath == null) {
            return false;
        }
        return CUtilFile.createDirectories(aPath.toFile());
    }

    public static boolean createDirectories(@NotNull File aFile) {
        if (!aFile.exists() && !aFile.mkdirs()) {
            LOG.error("Couldn't create the directory: {}", aFile);
            return false;
        }
        return true;
    }

    public static void createDirectoriesEx(@NotNull File aFile) throws CException {
        if (!CUtilFile.createDirectories(aFile)) {
            throw new CException(2211).append("Couldn't create directory ").append(aFile);
        }
    }

    public static void throwIfFileDoesntExist(@NotNull File aFile) throws CException {
        if (!aFile.exists()) {
            throw new CException(2211).append("File doesn't exist: ").append(aFile);
        }
    }

    @NotNull
    public static FileTime[] getFileTimes(@Nullable File aFile) {
        FileTime[] result = new FileTime[3];
        if (aFile != null) {
            try {
                BasicFileAttributes attr = Files.readAttributes(aFile.toPath(), BasicFileAttributes.class, new LinkOption[0]);
                result[0] = attr.creationTime();
                result[1] = attr.lastModifiedTime();
                result[2] = attr.lastAccessTime();
            }
            catch (Exception aE) {
                LOG.error("Error reading Creation Time from File {}", aFile);
            }
        }
        return result;
    }

    public static boolean setLastModifiedTime(@NotNull File aFile, @Nullable FileTime aTime) {
        return aTime != null && aFile.setLastModified(aTime.toMillis());
    }

    public static boolean setCreationTime(@NotNull File aFile, @Nullable FileTime aTime) {
        if (aTime != null) {
            try {
                Files.setAttribute(aFile.toPath(), "basic:creationTime", aTime, LinkOption.NOFOLLOW_LINKS);
                return true;
            }
            catch (IOException aE) {
                LOG.error(aE, "Error setting Creation Time from File {}", aFile);
            }
        }
        return false;
    }

    public static void copyFile(@NotNull Path aSource, @NotNull Path aDestination, boolean aOverwrite) throws IOException {
        aDestination.getParent().toFile().mkdirs();
        Files.copy(aSource, aDestination, aOverwrite ? OVERWRITE1 : NO_OVERWRITE1);
    }

    public static void moveFile(@NotNull Path aSource, @NotNull Path aDestination, boolean aOverwrite) throws IOException {
        Files.move(aSource, aDestination, aOverwrite ? OVERWRITE2 : NO_OVERWRITE2);
    }

    @NotNull
    public static Path getUserDirectory() {
        return FileSystems.getDefault().getPath(System.getProperty("user.dir"), new String[0]);
    }

    @NotNull
    private static List<String> readFilesInDirectory(@NotNull String aDirectoryPath) {
        File directory = new File(aDirectoryPath);
        File[] files = directory.listFiles();
        ArrayList<String> fileNames = new ArrayList<String>();
        if (files != null) {
            for (File file : files) {
                if (!file.isFile()) continue;
                fileNames.add(file.getName());
            }
        }
        return fileNames;
    }

    public static void removeAllFilesInDirectory(@NotNull File aDir) {
        if (!aDir.exists()) {
            LOG.error("The directory doesn't exist: {}", aDir);
            return;
        }
        if (!aDir.isDirectory()) {
            LOG.error("The given file is no directory: {}", aDir);
            return;
        }
        File[] files = aDir.listFiles();
        if (files != null) {
            for (File file : files) {
                boolean deleted = file.delete();
                if (deleted) continue;
                LOG.error("Couldn't delete the file: {}", file);
            }
        }
    }

    public static void overwrite(@NotNull File aFile, @NotNull String aContent) throws IOException {
        try (FileWriter writer = new FileWriter(aFile, false);){
            writer.write(aContent);
        }
    }
}

