/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.timer.records;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.ISlot;
import org.jetbrains.annotations.NotNull;

public final class CRecordTimer
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject("8dd21678-6bcc-47e5-aad4-a76d1b7273b2");
    public static final String NAME = "Timer";
    public static final String DESCRIPTION = "Timer slots filled in for a timer message.";
    public static final String SLOT_COUNTER = "f3a8aad8-390e-425d-939a-2e7c7df930e1";
    public static final String SLOT_OWNER = "b43221a6-5e03-4594-82eb-392a08cfea6a";
    public static final String SLOT_REPEATED_TIMER = "eb03ec52-bc92-4805-9556-3341dfa7dcac";
    public static final String SLOT_TIMEOUT = "425a62b4-aa1b-4ca4-8cbd-303582c9d762";
    public static final String SLOT_TIMER_HANDLE = "5d25d7ec-7d8a-4a65-b42a-f16bbbaabd45";
    public static final String[] NAMESPACES = new String[0];
    public static final boolean IS_NANO_SERVICE = false;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static long getCounter(@NotNull CRecord aRecord, long aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_COUNTER);
        if (slot == null) {
            return aDefault;
        }
        return (Long)slot.getValue();
    }

    public static CTargetAddress getOwner(@NotNull CRecord aRecord, CTargetAddress aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_OWNER);
        if (slot == null) {
            return aDefault;
        }
        return (CTargetAddress)slot.getValue();
    }

    public static boolean getRepeatedTimer(@NotNull CRecord aRecord, boolean aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_REPEATED_TIMER);
        if (slot == null) {
            return aDefault;
        }
        return (Boolean)slot.getValue();
    }

    public static long getTimeout(@NotNull CRecord aRecord, long aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_TIMEOUT);
        if (slot == null) {
            return aDefault;
        }
        return (Long)slot.getValue();
    }

    public static long getTimerHandle(@NotNull CRecord aRecord, long aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_TIMER_HANDLE);
        if (slot == null) {
            return aDefault;
        }
        return (Long)slot.getValue();
    }

    public static void setCounter(@NotNull CRecord aRecord, long aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.LONG, aValue);
        aRecord.addSlot(SLOT_COUNTER, slot);
    }

    public static void setOwner(@NotNull CRecord aRecord, CTargetAddress aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.TARGET_ADDRESS, aValue);
        aRecord.addSlot(SLOT_OWNER, slot);
    }

    public static void setRepeatedTimer(@NotNull CRecord aRecord, boolean aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.BOOLEAN, aValue);
        aRecord.addSlot(SLOT_REPEATED_TIMER, slot);
    }

    public static void setTimeout(@NotNull CRecord aRecord, long aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.LONG, aValue);
        aRecord.addSlot(SLOT_TIMEOUT, slot);
    }

    public static void setTimerHandle(@NotNull CRecord aRecord, long aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.LONG, aValue);
        aRecord.addSlot(SLOT_TIMER_HANDLE, slot);
    }
}

