/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.log;

import de.sillysky.nyssr.log.CLogDto;
import de.sillysky.nyssr.log.IMessageFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CDefaultMessageFormatter
implements IMessageFormatter {
    @Override
    @NotNull
    public String format(@NotNull CLogDto aDto) {
        ArrayList<String> list = new ArrayList<String>();
        this.getArguments(list, aDto);
        String text = aDto.getMessage();
        if (text == null) {
            text = "";
        }
        StringBuilder sb = new StringBuilder();
        if (list.isEmpty()) {
            sb.append(text);
        } else {
            for (String s : list) {
                text = this.replace(sb, text, s);
            }
            if (!text.isEmpty()) {
                sb.append(text);
            }
        }
        Throwable throwable = aDto.getThrowable();
        if (throwable != null) {
            sb.append("\n");
            this.getThrowableText(sb, throwable);
        }
        String formattedText = sb.toString();
        aDto.setFormattedText(formattedText);
        return formattedText;
    }

    private void getArguments(@NotNull Collection<String> aToFill, @NotNull CLogDto aDto) {
        Object[] oo;
        Supplier<?> supplier = aDto.getSupplier();
        if (supplier != null) {
            Object o = supplier.get();
            this.getArguments(aToFill, o);
        }
        if ((oo = aDto.getArguments()) != null) {
            this.getArguments(aToFill, oo);
        }
    }

    private void getArguments(@NotNull Collection<String> aToFill, @Nullable Object aObj) {
        if (aObj == null) {
            aToFill.add("null");
        } else if (aObj instanceof Supplier) {
            Supplier sup = (Supplier)aObj;
            Object o = sup.get();
            this.getArguments(aToFill, o);
        } else if (aObj instanceof Object[]) {
            Object[] oo;
            for (Object o : oo = (Object[])aObj) {
                this.getArguments(aToFill, o);
            }
        } else {
            String text = aObj.toString();
            aToFill.add(text);
        }
    }

    private void getCauseText(@NotNull String aText, @NotNull StringBuilder aSb, @NotNull Throwable aThrowable) {
        StackTraceElement[] stackTrace;
        if (!aText.isEmpty()) {
            aSb.append(aText).append(": ");
        }
        aSb.append(aThrowable.getClass().getName()).append(": ").append(aThrowable.getMessage()).append("\n");
        for (StackTraceElement e : stackTrace = aThrowable.getStackTrace()) {
            String className = e.getClassName();
            aSb.append("    at ");
            if (className.startsWith("java")) {
                aSb.append("java.base/");
            }
            aSb.append(className).append(".").append(e.getMethodName()).append("(").append(e.getFileName()).append(":").append(e.getLineNumber()).append(")").append("\n");
        }
    }

    private void getThrowableText(@NotNull StringBuilder aSb, @NotNull Throwable aThrowable) {
        this.getCauseText("", aSb, aThrowable);
        for (Throwable cause = aThrowable.getCause(); cause != null; cause = cause.getCause()) {
            this.getCauseText("Caused by", aSb, cause);
        }
    }

    private String replace(@NotNull StringBuilder aSb, @NotNull String aMsg, @NotNull String aArgument) {
        if (aMsg.isEmpty()) {
            if (aSb.length() > 0) {
                aSb.append(", ");
            }
            aSb.append(aArgument);
            return "";
        }
        int pos = aMsg.indexOf("{}");
        if (pos == -1) {
            aSb.append(aMsg);
            aSb.append(", ");
            aSb.append(aArgument);
            return "";
        }
        aSb.append(aMsg, 0, pos);
        aSb.append(aArgument);
        return aMsg.substring(pos + 2);
    }
}

