/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.service;

import de.sillysky.nyssr.impl.service.CServiceRegistry;
import de.sillysky.nyssr.impl.service.CServiceStarter;
import org.jetbrains.annotations.NotNull;

class CJobStopStartedStarter
implements Runnable {
    private final CServiceRegistry mServiceRegistry;
    private final CServiceStarter mStarter;

    CJobStopStartedStarter(@NotNull CServiceRegistry aServiceRegistry, @NotNull CServiceStarter aStarter) {
        this.mServiceRegistry = aServiceRegistry;
        this.mStarter = aStarter;
    }

    @Override
    public void run() {
        String name = this.mStarter.getName();
        CServiceRegistry.LOG.debug("Try to: stop service {}", name);
        this.mServiceRegistry.privateRemoveStartedStarter(name);
        try {
            this.mStarter.getServiceStarter().stop(this.mServiceRegistry);
            CServiceRegistry.LOG.info("Okay: Service {} stopped", name);
        }
        catch (Exception e) {
            CServiceRegistry.LOG.error(e, "Error: on stopping the service {}.", name);
        }
        this.mServiceRegistry.privateAddWaitingStarter(name, this.mStarter);
    }
}

