/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.namespace;

import de.sillysky.nyssr.address.CNamespaceAddress;
import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.address.CNodeId;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.common.CWellKnownNID;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.impl.namespace.IDependencies;
import de.sillysky.nyssr.impl.service.CServiceRegistry;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.message.CMessage;
import de.sillysky.nyssr.message.IPostMan;
import de.sillysky.nyssr.message.hook.EMessageHookCause;
import de.sillysky.nyssr.message.queue.IMessageQueue;
import de.sillysky.nyssr.message.queue.IMessageQueueRegistry;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.namespace.INamespaceInternal;
import de.sillysky.nyssr.nanoservice.INanoServiceRegistry;
import de.sillysky.nyssr.notification.records.CRecordNotifyNamespaceDeregistered;
import de.sillysky.nyssr.notification.records.CRecordNotifyNamespaceRegistered;
import de.sillysky.nyssr.result.CResult;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.ITargetRegistry;
import de.sillysky.nyssr.target.registry.records.CRecordNotifyTargetRegistered;
import de.sillysky.nyssr.thread.EThreadPriority;
import de.sillysky.nyssr.util.CUtilInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CNamespace
implements INamespace,
INamespaceInternal,
IPostMan {
    private static final ILogger LOG = CLoggerFactory.getLogger(CNamespace.class);
    private final CNamespaceAddress mAddress;
    private final String mName;
    private final String mDescription;
    private final IMessageQueueRegistry mMessageQueueRegistry;
    private final INanoServiceRegistry mNanoServiceRegistry;
    private final ITargetRegistry mTargetRegistry;
    private final boolean mInitialized;
    private final AtomicLong mMessagesHandled = new AtomicLong(0L);
    private final IDependencies mDependencies;

    CNamespace(@NotNull IDependencies aDependencies, @NotNull IId aNID, @NotNull String aDescription) throws CException {
        this.mDependencies = aDependencies;
        this.mAddress = new CNamespaceAddress(aNID, this.mDependencies.getKernelConfiguration().getNodeAddress());
        this.mName = aNID.toString();
        this.mDescription = aDescription;
        String nidString = aNID.toString();
        IId nid = this.mAddress.getNID();
        this.mDependencies.getMessageQueueRegistryFactory().createRegistry(nid, this);
        this.mMessageQueueRegistry = this.mDependencies.getMessageQueueRegistryFactory().createRegistry(nid, this);
        String qName = "NS-" + this.mName + "-MAIN (" + this.mDescription + ")";
        IId queueId = CIdFactory.fromObject("MAIN");
        this.mMessageQueueRegistry.createAndStartAsyncQueue(queueId, qName, 5);
        if (!CUtilInteger.isNumeric(nidString)) {
            Preferences prefs = this.mDependencies.getKernelConfiguration().getPreferences("namespace/" + nidString);
            try {
                String[] keys;
                for (String key : keys = prefs.keys()) {
                    String queueName;
                    if (!key.toLowerCase().startsWith("queue") || (queueName = prefs.get(key, "")) == null || (queueName = queueName.trim()).isEmpty()) continue;
                    this.createThread(queueName, EThreadPriority.NORMAL);
                }
            }
            catch (BackingStoreException e) {
                LOG.error(e, "Error reading properties for Namespace {}", aNID);
            }
        }
        this.mTargetRegistry = this.mDependencies.getTargetRegistryFactory().createTargetRegistry(this, this.mAddress, this.mMessageQueueRegistry);
        this.mNanoServiceRegistry = this.mDependencies.getNanoServiceRegistryFactory().createRegistry(nid);
        if (CWellKnownNID.SYSTEM.equals(nid)) {
            this.mNanoServiceRegistry.addNanoService(CRecordNotifyNamespaceRegistered.class);
            this.mNanoServiceRegistry.addNanoService(CRecordNotifyNamespaceDeregistered.class);
        }
        this.mInitialized = true;
    }

    @Override
    public void completeReceiver(@NotNull CEnvelope aEnvelope) {
        CNodeId nodeId;
        boolean changed = false;
        CTargetAddress receiver = aEnvelope.getReceiver();
        IId nid = receiver.getNID();
        if (!nid.isValid()) {
            nid = this.mAddress.getNID();
            changed = true;
        }
        if (!(nodeId = receiver.getNodeId()).isValid()) {
            nodeId = this.mAddress.getNodeId();
            changed = true;
        }
        if (changed) {
            receiver = new CTargetAddress(receiver.getTID(), nid, nodeId);
            aEnvelope.setReceiver(receiver);
        }
    }

    @Override
    public void deactivate() {
        LOG.debug("Deactivate {} {} {}", this.getClass().getSimpleName(), this.mName, System.identityHashCode(this));
        this.mNanoServiceRegistry.deactivate();
        this.mTargetRegistry.deactivate();
        this.mMessageQueueRegistry.deactivate();
        CServiceRegistry sr = CServiceRegistry.getInstance();
        sr.deregisterService(this);
    }

    @Override
    public void deliverMessage(@NotNull CMessage aMsg) throws Exception {
        ITarget tgt;
        CMessage msg = aMsg;
        msg = this.mDependencies.getMessageHookRegistry().invokeMessageHook(msg, EMessageHookCause.RECEIVE);
        if (msg == null) {
            return;
        }
        CEnvelope env = msg.getEnvelope();
        CTargetAddress rv = env.getReceiver();
        IId tid = rv.getTID();
        IId nid = rv.getNID();
        IId me = this.getNID();
        if (!me.equals(nid)) {
            LOG.error("Message with wrong NID={} found in my={} queue, EnvelopeId={}", nid, me, env.getInstanceId());
        }
        if ((tgt = this.mTargetRegistry.getTarget(tid)) == null) {
            LOG.warn("Could not find Target {} in namespace {}: msg={}", rv, this.getNID(), aMsg);
            env.setResult(new CResult(2507, "Unknown Target"));
            return;
        }
        tgt.handleMessage(msg);
        this.mMessagesHandled.incrementAndGet();
    }

    @Override
    @Nullable
    public CMessage dispatch(@NotNull CMessage aMsg) throws CException {
        if (!this.mInitialized) {
            return null;
        }
        CEnvelope env = aMsg.getEnvelope();
        CTargetAddress receiver = env.getReceiver();
        if (!this.isLocal(receiver.getNamespaceAddress())) {
            return aMsg;
        }
        IId rtid = receiver.getTID();
        if (env.isAnswer()) {
            if (rtid.isValid()) {
                return this.dispatchToQueue(aMsg);
            }
            LOG.error("Could not deliver answer {}.", aMsg);
        } else {
            if (rtid.isValid()) {
                return this.dispatchToQueue(aMsg);
            }
            IId mid = aMsg.getRecord().getId();
            INanoServiceRegistry serviceRegistry = this.getNanoServiceRegistry();
            boolean exist = serviceRegistry.existNanoService(mid);
            if (!exist) {
                if (CRecordNotifyTargetRegistered.ID.equals(mid)) {
                    return null;
                }
                CTargetAddress sender = env.getSender();
                if (sender.isValid()) {
                    CResult result = new CResult(2506).append("Address invalid, and NanoService not found. Send Back. MSG=").append(aMsg.toString());
                    LOG.error(result.getText());
                    env.setResult(result);
                    return aMsg;
                }
                CResult result = new CResult(2506).append("Address invalid, and NanoService not found. Drop. MSG=").append(aMsg.toString());
                LOG.error(result.toString());
                throw new CException(result);
            }
            env.setIsNanoServiceMessage(true);
            boolean dispatched = serviceRegistry.triggerObserver(mid, aMsg);
            if (!dispatched && env.wantAnswer()) {
                env.setResult(2305, "No observer found");
                LOG.error("No Observer found for Message {}", aMsg);
                return aMsg;
            }
        }
        return null;
    }

    @Nullable
    private CMessage dispatchToQueue(@NotNull CMessage aMsg) {
        CEnvelope env = aMsg.getEnvelope();
        IId tid = env.getReceiver().getTID();
        ITargetRegistry tReg = this.getTargetRegistry();
        IMessageQueue queue = tReg.getQueue(tid);
        if (queue == null) {
            LOG.warn("Target {} doesn't exist anymore, send back: {}", env.getReceiver(), aMsg);
            env.setResult(2507, "Unknown Target");
            return aMsg;
        }
        env.setBlocked(false);
        queue.offer(aMsg);
        return null;
    }

    public boolean equals(Object aObj) {
        if (this == aObj) {
            return true;
        }
        if (aObj == null) {
            return false;
        }
        if (this.getClass() != aObj.getClass()) {
            return false;
        }
        CNamespace other = (CNamespace)aObj;
        return this.mAddress.equals(other.mAddress);
    }

    @Override
    @NotNull
    public CNamespaceAddress getAddress() {
        return this.mAddress;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.mDescription;
    }

    @Override
    @NotNull
    public IMessageQueueRegistry getMessageQueueRegistry() {
        return this.mMessageQueueRegistry;
    }

    @Override
    @NotNull
    public IId getNID() {
        return this.mAddress.getNID();
    }

    @Override
    @NotNull
    public INanoServiceRegistry getNanoServiceRegistry() {
        return this.mNanoServiceRegistry;
    }

    @Override
    @NotNull
    public CNodeAddress getNodeAddress() {
        return this.mAddress.getNodeAddress();
    }

    @Override
    @NotNull
    public ITargetRegistry getTargetRegistry() {
        return this.mTargetRegistry;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.mAddress.hashCode();
        return result;
    }

    @Override
    public boolean isLocal(@Nullable IId aNID) {
        IId myNID = this.mAddress.getNID();
        return aNID == null || !aNID.isValid() || aNID.equals(myNID);
    }

    @Override
    public boolean isLocal(@NotNull CNamespaceAddress aAddress) {
        boolean result = this.isLocal(aAddress.getNID());
        if (result) {
            result = aAddress.getNodeAddress().isLocalNode();
        }
        return result;
    }

    @Override
    public void notifyRegistered() {
        String filter = "nid=" + String.valueOf(this.mAddress.getNID());
        CServiceRegistry.getInstance().registerService(INamespace.class, filter, (Object)this);
        this.mNanoServiceRegistry.notifyRegistered();
        this.mTargetRegistry.notifyRegistered();
    }

    @Override
    @NotNull
    public IId createThread(@NotNull String aName, @NotNull EThreadPriority aPriority) throws CException {
        IId queueId = CIdFactory.fromObject(aName);
        String qName = "NS-" + this.mName + "-" + aName;
        int priority = Math.max(Math.min(aPriority.getValue(), 10), 1);
        this.mMessageQueueRegistry.createAndStartAsyncQueue(queueId, qName, priority);
        return queueId;
    }

    @Override
    public long getMessageCountHandled() {
        return this.mMessagesHandled.get();
    }

    @Contract(pure=true)
    @NotNull
    public String toString() {
        return "Namespace [" + String.valueOf(this.mAddress) + "]";
    }

    @Override
    public int compareTo(@NotNull INamespace aOther) {
        return this.mAddress.getNID().toString().compareTo(aOther.getNID().toString());
    }
}

