/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.connection.registry;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.impl.network.transport.ITransport;
import de.sillysky.nyssr.network.connection.dto.CConnectionDto;
import java.time.LocalDateTime;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CConnectionEntry {
    @NotNull
    private CConnectionDto mConnection;
    private int mCosts;
    private LocalDateTime mStopTime;
    private final long mStartTime;
    private ITransport mTransport;
    private long mTimerHandle = 0L;

    CConnectionEntry(@NotNull CConnectionDto aConnection) {
        this.mConnection = aConnection;
        this.mStartTime = System.currentTimeMillis();
    }

    public boolean equals(Object aOther) {
        if (this == aOther) {
            return true;
        }
        if (aOther == null || this.getClass() != aOther.getClass()) {
            return false;
        }
        CConnectionEntry that = (CConnectionEntry)aOther;
        return this.mConnection.equals(that.mConnection);
    }

    public int hashCode() {
        return this.mConnection.hashCode();
    }

    @NotNull
    CConnectionDto getConnection() {
        return this.mConnection;
    }

    int getCosts() {
        return this.mCosts;
    }

    void setCosts(int aCosts) {
        this.mCosts = aCosts;
    }

    @Nullable
    ITransport getTransport() {
        return this.mTransport;
    }

    void setTransport(@Nullable ITransport aTransport) {
        this.mTransport = aTransport;
    }

    void stop() {
        this.mStopTime = LocalDateTime.now();
    }

    boolean isStopped() {
        return this.mStopTime != null;
    }

    void resume(@NotNull CConnectionDto aConnection) throws CException {
        this.mConnection = aConnection;
        this.mStopTime = null;
        this.mTransport.setConnection(aConnection);
    }

    long getStartTime() {
        return this.mStartTime;
    }

    void setTimerHandle(long aHandle) {
        this.mTimerHandle = aHandle;
    }

    long getTimerHandle() {
        return this.mTimerHandle;
    }
}

