/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.gatekeeper;

import de.sillysky.nyssr.impl.network.gatekeeper.CGateKeeper;
import de.sillysky.nyssr.impl.network.gatekeeper.IDependencies;
import de.sillysky.nyssr.kernel.configuration.IKernelConfiguration;
import de.sillysky.nyssr.namedb.INameDb;
import de.sillysky.nyssr.network.IConnectionRegistry;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.service.IServiceStarter;
import org.jetbrains.annotations.NotNull;

public final class CPackageNetworkGatekeeper
implements IServiceStarter,
IDependencies {
    private IService mService;
    private IKernelConfiguration mKernelConfiguration;
    private INameDb mNameDb;

    public void getDependencies(@NotNull IServiceDependencyList aDependencyList) {
        aDependencyList.add(IKernelConfiguration.class);
        aDependencyList.add(INameDb.class);
        aDependencyList.add(IConnectionRegistry.class);
    }

    public void start(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        if (this.mService == null) {
            this.mKernelConfiguration = (IKernelConfiguration)aServiceRegistry.getServiceOrThrow(IKernelConfiguration.class);
            this.mNameDb = (INameDb)aServiceRegistry.getServiceOrThrow(INameDb.class);
            this.mService = new CGateKeeper(this);
            this.mService.activate(aServiceRegistry);
        }
    }

    public void stop(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        if (this.mService != null) {
            this.mService.deactivate(aServiceRegistry);
            this.mService = null;
        }
    }

    @Override
    public IKernelConfiguration getKernelConfiguration() {
        return this.mKernelConfiguration;
    }

    @Override
    public INameDb getNameDb() {
        return this.mNameDb;
    }
}

