/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.microservice.registry.records;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISlot;
import org.jetbrains.annotations.NotNull;

public final class CRecordGetMicroServiceIds
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject((Object)"8035c42e-2996-4b43-8b90-136298ede09d");
    public static final String NAME = "GetMicroServiceIds";
    public static final String DESCRIPTION = "Get the IDs of the registered Micro Services.";
    public static final String SLOT_MICRO_SERVICE_IDS = "90005";
    public static final String[] NAMESPACES = new String[]{"SYSTEM"};
    public static final boolean IS_NANO_SERVICE = true;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static IId[] getMicroServiceIds(@NotNull CRecord aRecord, IId[] aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_MICRO_SERVICE_IDS);
        if (slot == null) {
            return aDefault;
        }
        return (IId[])slot.getValue();
    }

    public static void setMicroServiceIds(@NotNull CRecord aRecord, IId[] aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.ID_ARRAY, (Object)aValue);
        aRecord.addSlot(SLOT_MICRO_SERVICE_IDS, slot);
    }
}

