/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.microservice.registry.records;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.message.CMessage;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISlot;
import org.jetbrains.annotations.NotNull;

public final class CRecordForwardToMicroServiceInstance
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject((Object)"4dad52bd-3071-46d9-a79b-c5188e311131");
    public static final String NAME = "ForwardToMicroServiceInstance";
    public static final String DESCRIPTION = "Forward a Message to an instance of a given Micro Service ID. If more than one instance is registered, forward the message to a random instance.";
    public static final String SLOT_MESSAGE = "1";
    public static final String SLOT_MICRO_SERVICE_ID = "2";
    public static final String[] NAMESPACES = new String[]{"SYSTEM"};
    public static final boolean IS_NANO_SERVICE = true;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static CMessage getMessage(@NotNull CRecord aRecord, CMessage aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_MESSAGE);
        if (slot == null) {
            return aDefault;
        }
        return (CMessage)slot.getValue();
    }

    public static IId getMicroServiceId(@NotNull CRecord aRecord, IId aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_MICRO_SERVICE_ID);
        if (slot == null) {
            return aDefault;
        }
        return (IId)slot.getValue();
    }

    public static void setMessage(@NotNull CRecord aRecord, CMessage aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.MESSAGE, (Object)aValue);
        aRecord.addSlot(SLOT_MESSAGE, slot);
    }

    public static void setMicroServiceId(@NotNull CRecord aRecord, IId aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.ID, (Object)aValue);
        aRecord.addSlot(SLOT_MICRO_SERVICE_ID, slot);
    }
}

