/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.microservice.registry.service;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.microservice.registry.EListenerType;
import de.sillysky.nyssr.impl.microservice.registry.service.CListenerEntry;
import de.sillysky.nyssr.impl.microservice.registry.service.CListenerList;
import de.sillysky.nyssr.impl.microservice.registry.service.CListenerRegistry;
import de.sillysky.nyssr.impl.microservice.registry.service.CMicroServiceEntry;
import de.sillysky.nyssr.impl.microservice.registry.service.CMicroServiceInstanceEntry;
import de.sillysky.nyssr.impl.microservice.registry.service.IMicroServiceObserver;
import de.sillysky.nyssr.impl.microservice.registry.service.IMicroServiceRegistry;
import de.sillysky.nyssr.impl.microservice.registry.service.IMicroServiceRegistryObserver;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.microservice.collector.CMicroServiceDescription;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.time.CUtilDuration;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CMicroServiceRegistry
implements IMicroServiceRegistry,
IService {
    private static final ILogger LOG = CLoggerFactory.getLogger((String)"microservice.registry");
    private final Map<IId, CMicroServiceEntry> mMap = new ConcurrentHashMap<IId, CMicroServiceEntry>();
    private final Set<CTargetAddress> mOtherRegistries = new HashSet<CTargetAddress>();
    private final CListenerRegistry mListeners = new CListenerRegistry();
    private final AtomicReference<IMicroServiceRegistryObserver> mMicroServiceRegistryObserver = new AtomicReference();
    private IMicroServiceObserver mListenerInformer = null;

    CMicroServiceRegistry() {
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) {
        aServiceRegistry.registerService(IMicroServiceRegistry.class, (Object)this);
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        aServiceRegistry.deregisterService((Object)this);
    }

    @Override
    public void addOtherRegistry(@NotNull CTargetAddress aRegistry) {
        if (this.mOtherRegistries.add(aRegistry)) {
            LOG.info("Other MicroServiceRegistry added: {}", new Object[]{aRegistry});
        }
    }

    @Override
    public void removeMicroService(@NotNull IId aMicroServiceId, @NotNull IId aMicroServiceInstanceId, boolean aDoBroadcast) {
        CMicroServiceEntry entry = this.mMap.get(aMicroServiceId);
        if (entry == null) {
            LOG.warn("Delete MicroService Instance: Micro Service {} not found.", new Object[]{aMicroServiceId});
        } else {
            CMicroServiceInstanceEntry instanceEntry = entry.getInstanceById(aMicroServiceInstanceId);
            if (instanceEntry == null) {
                LOG.warn("Delete MicroService Instance: Instance {} not found.", new Object[]{aMicroServiceInstanceId});
            } else {
                this.removeMicroService(entry, instanceEntry, aDoBroadcast);
            }
        }
    }

    private void removeMicroService(@NotNull CMicroServiceEntry aEntry, @NotNull CMicroServiceInstanceEntry aInstanceEntry, boolean aDoBroadcast) {
        if (aEntry.removeInstance(aInstanceEntry)) {
            CMicroServiceDescription desc = aEntry.getMicroService();
            IId id = desc.getId();
            CTargetAddress address = aInstanceEntry.getTargetAddress();
            LOG.info("MicroService Instance removed: {}: MSId={}, InstanceId={}, Address={}", new Object[]{desc.getDescription(), id, aInstanceEntry.getInstanceId(), address});
            if (aDoBroadcast) {
                IMicroServiceRegistryObserver listener = this.mMicroServiceRegistryObserver.get();
                if (listener != null) {
                    listener.notifyInstanceRemoved(id, address);
                }
                boolean wasLastService = aEntry.getInstanceCount() == 0;
                this.informListenerAboutDeRegistration(id, wasLastService);
            }
        }
    }

    @Override
    public int getInstanceCount() {
        int count = 0;
        for (CMicroServiceEntry e : this.mMap.values()) {
            count += e.getInstanceCount();
        }
        return count;
    }

    @Override
    @NotNull
    public List<CTargetAddress> getInstanceAddresses(@NotNull IId aId) {
        ArrayList<CTargetAddress> list = new ArrayList<CTargetAddress>();
        CMicroServiceEntry entry = this.mMap.get(aId);
        if (entry != null) {
            for (CMicroServiceInstanceEntry i : entry.getInstances()) {
                list.add(i.getTargetAddress());
            }
        }
        return list;
    }

    @Override
    @NotNull
    public Collection<CMicroServiceEntry> getMicroServiceEntries() {
        return new ArrayList<CMicroServiceEntry>(this.mMap.values());
    }

    @Override
    @NotNull
    public IId[] getMicroServiceIds() {
        if (this.mMap.isEmpty()) {
            return new IId[0];
        }
        return this.mMap.keySet().toArray(new IId[0]);
    }

    @Override
    @NotNull
    public Collection<CMicroServiceDescription> getMicroServices() {
        ArrayList<CMicroServiceDescription> list = new ArrayList<CMicroServiceDescription>();
        for (CMicroServiceEntry e : this.mMap.values()) {
            list.add(e.getMicroService());
        }
        return list;
    }

    @Override
    @NotNull
    public Collection<CTargetAddress> getOtherRegistries() {
        return this.mOtherRegistries;
    }

    @Override
    @Nullable
    public CTargetAddress getRandomInstance(@NotNull IId aId) {
        CMicroServiceEntry entry = this.mMap.get(aId);
        if (entry == null) {
            return null;
        }
        return entry.getRandomInstance();
    }

    @Override
    public void notifyNodeDeleted(@NotNull CNodeAddress aNode) {
        for (CMicroServiceEntry e : this.mMap.values()) {
            e.notifyNodeDeleted(aNode);
        }
        this.dump();
    }

    @Override
    public void addMicroService(@NotNull CMicroServiceDescription aMicroService) {
        IId id = aMicroService.getId();
        CMicroServiceEntry e = this.mMap.get(id);
        if (e == null) {
            e = new CMicroServiceEntry(aMicroService);
            this.mMap.put(id, e);
            LOG.info("MicroService added: {}: id={}", new Object[]{aMicroService.getDescription(), id});
        }
    }

    @Override
    public void addMicroService(@NotNull IId aInstanceId, @NotNull CTargetAddress aInstanceAddress, @NotNull CMicroServiceDescription aMicroService, boolean aDoBroadcast) {
        IMicroServiceRegistryObserver listener;
        IId id = aMicroService.getId();
        CMicroServiceEntry e = this.mMap.get(id);
        if (e == null) {
            e = new CMicroServiceEntry(aMicroService);
            this.mMap.put(id, e);
        }
        e.addInstance(aInstanceId, aInstanceAddress, null);
        LOG.info("Okay: MicroService Instance added: {}: id={}, instance={}", new Object[]{aMicroService.getDescription(), id, aInstanceAddress});
        this.dump();
        if (aDoBroadcast && (listener = this.mMicroServiceRegistryObserver.get()) != null) {
            listener.notifyInstanceAdded(e.getMicroService(), aInstanceAddress);
        }
        boolean isFirstRegisteredService = e.getInstanceCount() == 1;
        this.informListenerAboutRegistration(aMicroService, isFirstRegisteredService);
    }

    private void informListenerAboutRegistration(@NotNull CMicroServiceDescription aDesc, boolean aIsFirstRegisteredService) {
        IId id;
        CListenerList list;
        if (this.mListenerInformer != null && (list = this.mListeners.get(id = aDesc.getId())) != null) {
            Iterator<CListenerEntry> iterator = list.iterator();
            while (iterator.hasNext()) {
                CListenerEntry entry = iterator.next();
                EListenerType type = entry.getType();
                if (type != EListenerType.ON_ANY_CHANGE && !aIsFirstRegisteredService) continue;
                this.mListenerInformer.notifyMicroServiceAdded(aDesc, entry.getAddress());
            }
        }
    }

    private void informListenerAboutDeRegistration(@NotNull IId aId, boolean aWasLastRegisteredService) {
        CListenerList list;
        if (this.mListenerInformer != null && (list = this.mListeners.get(aId)) != null) {
            Iterator<CListenerEntry> iterator = list.iterator();
            while (iterator.hasNext()) {
                CListenerEntry entry = iterator.next();
                EListenerType type = entry.getType();
                if (type != EListenerType.ON_ANY_CHANGE && !aWasLastRegisteredService) continue;
                this.mListenerInformer.notifyMicroServiceRemoved(aId, entry.getAddress());
            }
        }
    }

    @Override
    public void removeOtherRegistry(@NotNull CTargetAddress aRegistry) {
        if (this.mOtherRegistries.remove(aRegistry)) {
            LOG.info("Other MicroServiceRegistry removed: {}", new Object[]{aRegistry});
        }
    }

    @Override
    public int size() {
        return this.mMap.size();
    }

    @Override
    public void setListenerInformer(@Nullable IMicroServiceObserver aListenerInformer) {
        this.mListenerInformer = aListenerInformer;
    }

    @Override
    public void addListener(@NotNull IId aMsId, @NotNull CTargetAddress aAddress, @NotNull EListenerType aType) {
        CListenerEntry e = new CListenerEntry(aMsId, aAddress, aType);
        this.mListeners.add(e);
    }

    @Override
    public void removeListener(@NotNull IId aMsId, @NotNull CTargetAddress aAddress) {
        this.mListeners.remove(aMsId, aAddress);
    }

    @Override
    @Nullable
    public CMicroServiceEntry getMicroService(@NotNull IId aId) {
        return this.mMap.get(aId);
    }

    public void setMicroServiceRegistryObserver(@Nullable IMicroServiceRegistryObserver aObserver) {
        this.mMicroServiceRegistryObserver.set(aObserver);
    }

    private void dump() {
        if (LOG.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(250 + this.mMap.size() * 120);
            sb.append(CUtilString.LINE_CRLF);
            sb.append("| Currently registered MicroServices:\n");
            for (Map.Entry<IId, CMicroServiceEntry> e : this.mMap.entrySet()) {
                CMicroServiceEntry entry = e.getValue();
                for (CMicroServiceInstanceEntry instance : entry.getInstances()) {
                    CMicroServiceDescription desc = entry.getMicroService();
                    sb.append("| ");
                    sb.append(String.format("%-10.10s ", desc.getId()));
                    sb.append(String.format("%-45.45s ", desc.getDescription()));
                    sb.append(String.format("%-12.12s ", instance.getInstanceId()));
                    sb.append(String.format("%-36.36s ", instance.getTargetAddress()));
                    ZonedDateTime timeAdded = instance.getTimeAdded();
                    ZonedDateTime now = ZonedDateTime.now();
                    Duration between = Duration.between(timeAdded, now);
                    long millis = between.toMillis();
                    String timeString = CUtilDuration.millisToShortDHMS((long)millis);
                    sb.append(String.format("%10.10s ", timeString));
                    sb.append("\n");
                }
            }
            sb.append(CUtilString.LINE_CRLF);
            LOG.debug(sb.toString());
        }
    }
}

