/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.model.events;

import de.sillysky.nyssr.json.CJsonArray;
import de.sillysky.nyssr.remoteskin.model.events.CEventTreeNode;
import de.sillysky.nyssr.remoteskin.model.events.IRemoteSkinEvent;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CEventTreeNodes
implements IRemoteSkinEvent {
    private final List<CEventTreeNode> mNodes = new ArrayList<CEventTreeNode>();

    private CEventTreeNodes(List<CEventTreeNode> aNodes) {
        this.mNodes.addAll(aNodes);
    }

    @Nullable
    public static CEventTreeNodes create(@Nullable Object aValue) {
        ArrayList<CEventTreeNode> nodes = new ArrayList<CEventTreeNode>();
        if (aValue instanceof CJsonArray) {
            CJsonArray arr = new CJsonArray();
            for (Object o : arr.getChildren()) {
                CEventTreeNode event = CEventTreeNode.create(o);
                if (event == null) continue;
                nodes.add(event);
            }
            return new CEventTreeNodes(nodes);
        }
        return null;
    }

    @NotNull
    public List<CEventTreeNode> getNodes() {
        return this.mNodes;
    }

    public void addNode(@NotNull CEventTreeNode aNode) {
        this.mNodes.add(aNode);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.mNodes.size() + " entries";
    }

    @Override
    @NotNull
    public Object toJson() {
        CJsonArray arr = new CJsonArray();
        for (CEventTreeNode node : this.mNodes) {
            Object o = node.toJson();
            arr.add(o);
        }
        return arr;
    }
}

