/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.model.events;

import de.sillysky.nyssr.json.CJsonArray;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.remoteskin.model.enums.EEditChangeType;
import de.sillysky.nyssr.remoteskin.model.events.CEventIdAndValue;
import de.sillysky.nyssr.remoteskin.model.events.IRemoteSkinEvent;
import de.sillysky.nyssr.util.CUtilEnum;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CEventTreeChangeNotification
implements IRemoteSkinEvent {
    private static final String VALUES = "values";
    private static final String TYPE = "type";
    private final Set<CEventIdAndValue> mValues = new HashSet<CEventIdAndValue>();
    private final EEditChangeType mType;

    public CEventTreeChangeNotification(@NotNull EEditChangeType aType) {
        this.mType = aType;
    }

    @Nullable
    public static CEventTreeChangeNotification create(@Nullable Object aValue) {
        if (aValue instanceof CJsonObject) {
            CJsonObject jo = (CJsonObject)aValue;
            EEditChangeType type = EEditChangeType.unknown;
            Object o = jo.getValue(TYPE);
            if (o instanceof String) {
                type = (EEditChangeType)((Object)CUtilEnum.fromString(EEditChangeType.class, (String)((String)o), (Object)((Object)EEditChangeType.unknown)));
            }
            if ((o = jo.getValue(VALUES)) instanceof CJsonArray) {
                CJsonArray arr = (CJsonArray)o;
                CEventTreeChangeNotification event = new CEventTreeChangeNotification(type);
                for (Object child : arr.getChildren()) {
                    CEventIdAndValue ev = CEventIdAndValue.create(child);
                    if (ev == null) continue;
                    event.addValue(ev);
                }
                return event;
            }
        }
        return null;
    }

    public void addValue(@NotNull CEventIdAndValue aValue) {
        this.mValues.add(aValue);
    }

    public boolean isEmpty() {
        return this.mValues.isEmpty();
    }

    public Collection<CEventIdAndValue> getValues() {
        return this.mValues;
    }

    public EEditChangeType getType() {
        return this.mType;
    }

    @Override
    @NotNull
    public Object toJson() {
        if (this.isEmpty()) {
            return "";
        }
        CJsonObject jo = new CJsonObject(true);
        jo.put(TYPE, (Object)this.mType.name());
        CJsonArray arr = new CJsonArray();
        for (CEventIdAndValue v : this.mValues) {
            arr.add(v.toJson());
        }
        jo.put(VALUES, (Object)arr);
        return jo;
    }
}

