/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.model.events;

import de.sillysky.nyssr.json.CJsonArray;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonBoolean;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonInteger;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonString;
import de.sillysky.nyssr.remoteskin.model.events.IRemoteSkinEvent;
import de.sillysky.nyssr.remoteskin.model.types.CDataKeyModifiers;
import de.sillysky.nyssr.util.swing.key.EKeyModifier;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CEventMouseNotification
implements IRemoteSkinEvent {
    public static final String CLICK_COUNT = "clickcount";
    public static final String MODIFIER = "modifier";
    public static final String POPUP_TRIGGER = "popup";
    public static final String SCREEN_X = "screenx";
    public static final String SCREEN_Y = "screeny";
    public static final String X = "x";
    public static final String Y = "y";
    public static final String ROW_ID = "rowid";
    public static final String COLUMN_ID = "columnid";
    public static final String VALUE = "value";
    private final List<EKeyModifier> mKeyModifiers = new ArrayList<EKeyModifier>();
    private int mClickCount;
    private Point mPosition;
    private Point mScreenPosition;
    private boolean mIsPopupTrigger;
    private String mRowId;
    private String mColumnId;
    private String mValue;

    @Nullable
    public static CEventMouseNotification create(@Nullable Object aValue) {
        if (aValue instanceof CJsonObject) {
            CDataKeyModifiers mod;
            CJsonObject jo = (CJsonObject)aValue;
            CEventMouseNotification event = new CEventMouseNotification();
            int clickCount = CUtilJsonInteger.fromJson((CJsonObject)jo, (String)CLICK_COUNT, (int)0);
            event.setClickCount(clickCount);
            int x = CUtilJsonInteger.fromJson((CJsonObject)jo, (String)X, (int)0);
            int y = CUtilJsonInteger.fromJson((CJsonObject)jo, (String)Y, (int)0);
            event.setPosition(new Point(x, y));
            x = CUtilJsonInteger.fromJson((CJsonObject)jo, (String)SCREEN_X, (int)0);
            y = CUtilJsonInteger.fromJson((CJsonObject)jo, (String)SCREEN_Y, (int)0);
            event.setScreenPosition(new Point(x, y));
            Object o1 = jo.getValue(MODIFIER);
            if (o1 != null && (mod = CDataKeyModifiers.create(o1)) != null) {
                for (EKeyModifier modifier : mod.getModifiers()) {
                    event.addKeyModifier(modifier);
                }
            }
            boolean isPopupTrigger = CUtilJsonBoolean.fromJson((CJsonObject)jo, (String)POPUP_TRIGGER, (boolean)false);
            event.setPopupTrigger(isPopupTrigger);
            String value = CUtilJsonString.fromJson((CJsonObject)jo, (String)VALUE, (String)"");
            event.setValue(value);
            String rowId = CUtilJsonString.fromJson((CJsonObject)jo, (String)ROW_ID, (String)"");
            event.setRowId(rowId);
            String columnId = CUtilJsonString.fromJson((CJsonObject)jo, (String)COLUMN_ID, (String)"");
            event.setColumnId(columnId);
            return event;
        }
        return null;
    }

    public int getClickCount() {
        return this.mClickCount;
    }

    public void setClickCount(int aClickCount) {
        this.mClickCount = aClickCount;
    }

    @NotNull
    public Point getPosition() {
        return this.mPosition;
    }

    public void setPosition(Point aPosition) {
        this.mPosition = aPosition;
    }

    public Point getScreenPosition() {
        return this.mScreenPosition;
    }

    public void setScreenPosition(Point aScreenPosition) {
        this.mScreenPosition = aScreenPosition;
    }

    @NotNull
    public List<EKeyModifier> getKeyModifiers() {
        return this.mKeyModifiers;
    }

    public void addKeyModifier(@NotNull EKeyModifier aKeyModifier) {
        this.mKeyModifiers.add(aKeyModifier);
    }

    public boolean isPopupTrigger() {
        return this.mIsPopupTrigger;
    }

    public void setPopupTrigger(boolean aPopupTrigger) {
        this.mIsPopupTrigger = aPopupTrigger;
    }

    public String getRowId() {
        return this.mRowId;
    }

    public void setRowId(String aRowId) {
        this.mRowId = aRowId;
    }

    public String getColumnId() {
        return this.mColumnId;
    }

    public void setColumnId(String aColumnId) {
        this.mColumnId = aColumnId;
    }

    @NotNull
    public String getValue() {
        return this.mValue;
    }

    public void setValue(String aValue) {
        this.mValue = aValue;
    }

    @Override
    @NotNull
    public Object toJson() {
        CJsonObject jo = new CJsonObject(true);
        jo.put(CLICK_COUNT, (Object)this.mClickCount);
        if (this.mPosition != null) {
            jo.put(X, (Object)this.mPosition.x);
            jo.put(Y, (Object)this.mPosition.y);
        }
        if (this.mScreenPosition != null) {
            jo.put(SCREEN_X, (Object)this.mScreenPosition.x);
            jo.put(SCREEN_Y, (Object)this.mScreenPosition.y);
        }
        CDataKeyModifiers mod = new CDataKeyModifiers();
        mod.addModifiers(this.mKeyModifiers);
        CJsonArray arr = mod.toJson();
        jo.put(MODIFIER, (Object)arr);
        jo.put(POPUP_TRIGGER, (Object)this.mIsPopupTrigger);
        jo.put(ROW_ID, (Object)this.mRowId);
        jo.put(COLUMN_ID, (Object)this.mColumnId);
        jo.put(VALUE, (Object)(this.mValue == null ? "" : this.mValue));
        return jo;
    }
}

