/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.model.events;

import de.sillysky.nyssr.json.CJsonArray;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonBoolean;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonString;
import de.sillysky.nyssr.remoteskin.model.events.IRemoteSkinEvent;
import de.sillysky.nyssr.remoteskin.model.types.CDataKeyModifiers;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.swing.key.EKeyModifier;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CEventMenuNotification
implements IRemoteSkinEvent {
    public static final String KEY_CMD = "cmd";
    public static final String KEY_MODIFIERS = "mod";
    public static final String KEY_SELECTED = "selected";
    public static final boolean DEFAULT_SELECTED = false;
    private final String mCommand;
    private final Set<EKeyModifier> mModifiers = new HashSet<EKeyModifier>();
    private final boolean mSelected;

    public CEventMenuNotification(@NotNull String aCommand, @NotNull Collection<EKeyModifier> aModifiers, boolean aSelected) {
        this.mCommand = aCommand;
        this.mModifiers.addAll(aModifiers);
        this.mSelected = aSelected;
    }

    @Nullable
    public static CEventMenuNotification create(@Nullable Object aValue) {
        if (aValue instanceof CJsonObject) {
            CJsonObject jo = (CJsonObject)aValue;
            String cmd = CUtilJsonString.fromJson((CJsonObject)jo, (String)KEY_CMD, (String)"");
            Object value = jo.getValue(KEY_MODIFIERS);
            CDataKeyModifiers mod = CDataKeyModifiers.create(value);
            if (CUtilString.isValid((String)cmd) && mod != null) {
                Collection<EKeyModifier> modifiers = mod.getModifiers();
                boolean selected = CUtilJsonBoolean.fromJson((CJsonObject)jo, (String)KEY_SELECTED, (boolean)false);
                return new CEventMenuNotification(cmd, modifiers, selected);
            }
        }
        return null;
    }

    public boolean isSelected() {
        return this.mSelected;
    }

    @NotNull
    public String getCommand() {
        return this.mCommand;
    }

    @NotNull
    public Collection<EKeyModifier> getModifiers() {
        return this.mModifiers;
    }

    @Override
    @NotNull
    public Object toJson() {
        CJsonObject jo = new CJsonObject(true);
        jo.put(KEY_CMD, (Object)this.mCommand);
        CDataKeyModifiers mod = new CDataKeyModifiers();
        mod.addModifiers(this.mModifiers);
        CJsonArray arr = mod.toJson();
        jo.put(KEY_MODIFIERS, (Object)arr);
        if (this.mSelected) {
            jo.put(KEY_SELECTED, (Object)this.mSelected);
        }
        return jo;
    }
}

