/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table;

import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table.CAbstractCellRenderer;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table.CCell;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table.CColumn;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table.CColumnModel;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table.CTable;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table.CTableModel;
import de.sillysky.nyssr.util.CUtilString;
import java.awt.Component;
import java.text.DecimalFormat;
import javax.swing.JLabel;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;

public class CTableCellRendererNumber
extends CAbstractCellRenderer {
    private static final long serialVersionUID = -8245719132035159048L;

    public CTableCellRendererNumber(CTable aTable) {
        super(aTable);
    }

    @Override
    public Component getTableCellRendererComponent(@NotNull JTable aTable, Object aValue, boolean aIsSelected, boolean aHasFocus, int aRowIndex, int aColumnIndex) {
        CTableModel model = this.getTable().getMyModel();
        CColumnModel columnModel = model.getColumnModel();
        CColumn column = columnModel.getColumnByIndex(aColumnIndex);
        CCell cell = model.getCellOrNull(aColumnIndex, aRowIndex);
        JLabel component = (JLabel)super.getTableCellRendererComponent(aTable, aValue, aIsSelected, aHasFocus, aRowIndex, aColumnIndex);
        if (cell != null) {
            String value = "";
            if (column != null) {
                String format = column.getFormat();
                value = CUtilString.isValid((String)format) ? new DecimalFormat(format).format(aValue) : aValue.toString();
            }
            JLabel label = new JLabel(value);
            label.setHorizontalAlignment(4);
            component = label;
        }
        if (cell != null) {
            this.handleBackground(component, cell, aIsSelected);
            this.handleForeground(component, cell, aIsSelected);
            this.handleBorder(component, cell, aHasFocus);
            this.handleFont(component, cell);
        }
        return component;
    }
}

